/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.DataSourceSapDBBase;
import com.sap.dbtech.jdbcext.XAConnectionSapDB;
import com.sap.dbtech.jdbcext.XATrace;
import com.sap.dbtech.jdbcext.XATransaction;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;

public class XADataSourceSapDB
extends DataSourceSapDBBase
implements XADataSource,
Referenceable {
    private XATrace xatrace;
    private boolean initialized = false;
    private Hashtable transactions = new Hashtable();
    private GarbageCollector garbagecollector = new GarbageCollector(1000);

    public XADataSourceSapDB() {
        this.garbagecollector.start();
    }

    public XAConnection getXAConnection() {
        Properties properties = (Properties)this.connectProperties.clone();
        if (!this.initialized) {
            this.createXATrace();
        }
        return new XAConnectionSapDB(properties, this, this.xatrace);
    }

    public XAConnection getXAConnection(String string, String string2) {
        Properties properties = (Properties)this.connectProperties.clone();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        if (!this.initialized) {
            this.createXATrace();
        }
        return new XAConnectionSapDB(properties, this, this.xatrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createXATrace() {
        block6: {
            try {
                String string = this.getXATrace();
                if (string == null) {
                    Object var5_2 = null;
                    this.initialized = true;
                    return;
                }
                PrintWriter printWriter = this.getLogWriter();
                if (printWriter != null && string.equalsIgnoreCase("true")) {
                    this.xatrace = new XATrace(printWriter);
                }
                if (printWriter != null) break block6;
                try {
                    this.xatrace = new XATrace(string);
                }
                catch (IOException iOException) {
                    Object var5_3 = null;
                    this.initialized = true;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.initialized = true;
                throw throwable;
            }
        }
        Object var5_4 = null;
        this.initialized = true;
    }

    XATransaction getXATransaction(Xid xid) {
        return (XATransaction)this.transactions.get(xid);
    }

    void addXATransaction(XATransaction xATransaction) {
        this.transactions.put(xATransaction.xid, xATransaction);
    }

    void removeXATransaction(Xid xid) {
        this.transactions.remove(xid);
    }

    Xid[] getAllPrepared() {
        Vector<Xid> vector = new Vector<Xid>();
        Enumeration enumeration = this.transactions.elements();
        while (enumeration.hasMoreElements()) {
            XATransaction xATransaction = (XATransaction)enumeration.nextElement();
            if (xATransaction.getStatus() != 3) continue;
            vector.add(xATransaction.xid);
        }
        return vector.toArray(new Xid[vector.size()]);
    }

    private Object outer() {
        return this;
    }

    public Reference getReference() throws NamingException {
        return this.createReference(this.getClass().getName());
    }

    class GarbageCollector
    extends Thread {
        ArrayList toBeRolledBack = new ArrayList();
        ArrayList toBeRemoved = new ArrayList();
        int delay;

        GarbageCollector(int n) {
            super("SAPDB XA Timeout Manager " + XADataSourceSapDB.this.outer().hashCode());
            this.delay = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block15: while (true) {
                Object object;
                Object object2;
                Object object3;
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.toBeRemoved.clear();
                this.toBeRolledBack.clear();
                Object object4 = XADataSourceSapDB.this.outer();
                synchronized (object4) {
                    object3 = XADataSourceSapDB.this.transactions.elements();
                    long l = System.currentTimeMillis();
                    while (object3.hasMoreElements()) {
                        object2 = (XATransaction)object3.nextElement();
                        if (((XATransaction)object2).getStatus() == 2) {
                            this.toBeRemoved.add(((XATransaction)object2).xid);
                            continue;
                        }
                        if (((XATransaction)object2).timeOutTime >= l) continue;
                        this.toBeRolledBack.add(((XATransaction)object2).xid);
                    }
                }
                object3 = this.toBeRolledBack.iterator();
                while (object3.hasNext()) {
                    Xid xid = (Xid)object3.next();
                    if (XADataSourceSapDB.this.xatrace != null) {
                        XADataSourceSapDB.this.xatrace.trace(xid, "rollback (timeout)");
                    }
                    object = XADataSourceSapDB.this.outer();
                    synchronized (object) {
                        object2 = XADataSourceSapDB.this.getXATransaction(xid);
                        if (object2 != null) {
                            try {
                                ((XATransaction)object2).rollbackRelease();
                            }
                            catch (SQLException sQLException) {
                                try {
                                    ((XATransaction)object2).physicalConnection.close();
                                }
                                catch (SQLException sQLException2) {
                                    // empty catch block
                                }
                                ((XATransaction)object2).setStatus(2);
                            }
                        }
                    }
                }
                Iterator iterator = this.toBeRemoved.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block15;
                    object = (Xid)iterator.next();
                    if (XADataSourceSapDB.this.xatrace != null) {
                        XADataSourceSapDB.this.xatrace.trace((Xid)object, "forget (timeout)");
                    }
                    object2 = XADataSourceSapDB.this.outer();
                    synchronized (object2) {
                        XADataSourceSapDB.this.removeXATransaction((Xid)object);
                    }
                }
                break;
            }
        }
    }
}

