/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.util;

public class VersionInfo
{
    private int majorVersion    = 7;
    private int minorVersion    = 4;
    private int clVersion       = 4;  //Correction Level
    private int plVersion       = 0;  //Patch Level
    private String buildNumber = "Build 000-000-000-000";    //build number string;
    private String packagePrefix = "";

    public VersionInfo (int amajorVersion,
                        int aminorVersion,
                        int aclVersion,
                        int aplVersion,
                        String aBuildNumber ) {

        this.majorVersion = amajorVersion;
        this.minorVersion = aminorVersion;
        this.clVersion = aclVersion;
        this.plVersion = aplVersion;
        this.buildNumber = aBuildNumber;
    }

    public VersionInfo (
            String packageName,
            String defaultString)
    {
        StringBuffer result = new StringBuffer ();
        Package p;

        try {
            p = Package.getPackage (packageName);
            if (p != null) {
                result.append ("package ");
                result.append (p.getName ());
                result.append (", ");
                result.append (p.getImplementationTitle ());
                result.append (", ");
                result.append (p.getImplementationVendor ());
                result.append (", ");
                this.packagePrefix=result.toString ();

                parseVersion (p.getImplementationVersion ());
            }
        }
        catch (Exception exc) {
            this.packagePrefix = defaultString;
        }
    }

    public void parseVersion (String VersionString) {
        /*parser assumes a synthax of VersionString like "7.4.2 Build 000-000-000-000 "*/
        int startpos=0, endpos=0, curpos=0;
//        while (! Character.isSpaceChar(VersionString.charAt(curpos)))
//          curpos++;
        while ( Character.isSpaceChar(VersionString.charAt(curpos)))
          curpos++;
        startpos = curpos;
        while ( VersionString.charAt(curpos) != '.')
          curpos++;
        endpos = curpos;
        this.majorVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
        startpos = ++curpos;
        while ( VersionString.charAt(curpos) != '.')
          curpos++;
        endpos = curpos;
        this.minorVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
        startpos = ++curpos;
        while (! Character.isSpaceChar(VersionString.charAt(curpos)))
          curpos++;
        endpos = curpos;
        this.clVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
        while ( Character.isSpaceChar(VersionString.charAt(curpos)))
          curpos++;
        this.buildNumber = VersionString.substring(curpos);
        while (! Character.isSpaceChar(VersionString.charAt(curpos)))
          curpos++;
        while ( Character.isSpaceChar(VersionString.charAt(curpos)))
          curpos++;
        startpos = curpos;
        while ( VersionString.charAt(curpos) != '-')
          curpos++;
        endpos = curpos;
        String myString = VersionString.substring(startpos, endpos);
        this.plVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
    }

    public int getMajorVersion (){
        return this.majorVersion;
    }

    public int getMinorVersion (){
        return this.minorVersion;
    }

    public int getMinorMinorVersion (){
        return this.clVersion;
    }

    public int getCorrectionLevel (){
        return this.plVersion;
    }

    public String getVersionName (){
        return this.buildNumber;
    }

    public String getPackagePrefix (){
        return this.packagePrefix;
    }

    public String
    toString ()
    {
        StringBuffer result = new StringBuffer();

        result.append(this.packagePrefix);
        result.append(this.majorVersion);
        result.append('.');
        result.append(this.minorVersion);
        result.append('.');
        result.append(this.clVersion);
        result.append("    ");
        result.append(this.buildNumber);
        return result.toString();
    }
}
