
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: ini_file.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */


#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include "aca.h"

   /* 
   	Return a section's name of the next section 
   */
   static char *getnext_section(FILE *f, char *buff)
   {
      int	c, last=0;
      char	*loc;
   
      _D(" getnext_section()");
   
      buff[0] = '\0';
      while(1) {
         while (!feof(f)) {
            c=getc(f);
            if (c=='[' && last=='\n') 
               break;
            last = c;
         }	
         if (feof(f)) 
            return NULL;
         fgets(buff, 256, f);
         if (strlen(buff) < 3)
            continue;
	
	/* FIXME: now implement '[SectioName]\n' only, 
		  but '[SectioName] \n' isn't..
	*/	  
            
         if (!(loc=strchr(buff, ']')))		
            continue;	
         if (*(loc+1) != '\n')
            continue;
         else	
            *loc = '\0';
         return buff;
      }	
   }

   static void cpy_section(FILE *f_old, FILE *f_new)
   {
      int	c, last=0;
   
      _D(" INI_cpy_section()");
   
      while (!feof(f_old)) {
         c=getc(f_old);
         if (c=='\n' && last=='\n') { 
            ungetc(c, f_old);
            break;
         }
         last = c;
         if (!feof(f_old))
            fputc(c, f_new);
      }
   }

   int INI_goto_section(FILE *f, char *section)
   {
      char	buff[MAXSIZ_SECTION_NAME];
   
      _D(" INI_goto_section()");
     
      if (!section) return FALSE;
   
      rewind(f);
      while(!feof(f)) {
         if (getnext_section(f, buff)) {
            if (!strcmp(buff, section))
               return TRUE;
         }
      }		
      return FALSE;	 	
   }

   int INI_init_data(INI_SectionData *sdata, char *value, char *content)
   {
   	INI_SectionData	*p;
   	
   	_D(" set_data()");
   	
   	for(p=sdata; p->value != NULL; p++) 
   		if (!strcmp(p->value, value)) {
   			if (*p->value_call_fn) 
   				p->value_call_fn(p, value, content);
   			else
   				p->content = strdup(content);	
   			return TRUE;
   		}	
   	return FALSE;	
   } 

   int INI_set_data(INI_SectionData *sdata, char *value, char *content)
   {
   	INI_SectionData	*p;
   	
   	_D(" INI_set_data()");
   	
   	for(p=sdata; p->value != NULL; p++) 
   		if (!strcmp(p->value, value)) {
   			if (p->content) free((void *) p->content); 	/* ??? */
   			p->content = strdup(content);
   			return TRUE;
   		}	
   	return FALSE;	
   } 

   INI_SectionData *INI_load_section(FILE *f, INI_Section *sect) 
   {
	char 	value[MAXSIZ_SECTION_CONTENT+MAXSIZ_SECTION_VALUE],
		*content = chN;
	int	re=FALSE;	
	
	_D(" INI_load_section()");
	
	while (!feof(f)) {	
		*value = '\0';
   		fgets(value, MAXSIZ_SECTION_CONTENT+MAXSIZ_SECTION_VALUE, f);
   		if (!strcmp(value, "\n")) break;
   		if (!(content = separe_str(value, '='))) 
   			continue;
   		else {
   			if (*sect->sect_call_fn) 
   				sect->sect_call_fn(sect, value, content);
   			if (INI_init_data(sect->data, value, content))
   				re = TRUE;
   		}		
	}
	sect->flag |= SECT_LOADED;
	sect->flag &= ~SECT_LOAD;
	return (re ? sect->data : (INI_SectionData *) NULL);
   }


   /*
	Load all sestions (if it is need..)  
   */
   int INI_load(aca_INI *ini) 
   {
      FILE		*f;
      INI_Section	*sect = NULL;
      char		sname[MAXSIZ_SECTION_NAME];
   
      _D( " INI_load()");
   
      if ((f = aca_fileopen(ini->filename, "r", TRUE)) == NULL)
         return FALSE;
   
      while(getnext_section(f, sname)) {
         if ((sect = INI_flag_load(ini, sname)))
         	INI_load_section(f, sect); 
      }
      fclose(f);
      return TRUE;
   }
   
   static void save_sect(FILE *f, INI_Section *sect)
   {
  	INI_SectionData	*sect_d;
  	
  	fprintf(f, "\n\n[%s]\n", sect->name);
  	sect->flag &= ~SECT_SAVE;
  	sect->flag |= SECT_SAVED;
  	for(sect_d=sect->data; sect_d->value != NULL; sect_d++) {
   		if (!sect_d->content)
   			continue;
   		fprintf(f, "%s=%s\n", sect_d->value, sect_d->content);			
   	}
   	fputc('\n', f);
   }
   
   /*
	Save all sections (if it is need..)  
   */
   int INI_save(aca_INI *ini) 
   {
      	FILE		*f_old, *f_new;
 	INI_Section	*sect;
   	char		buff[264],
   			sname[MAXSIZ_SECTION_NAME];

      	_D( " INI_save()");
   
      	if ((f_old = aca_fileopen(ini->filename, "r", TRUE)) == NULL)
        	return FALSE;
   	
   	sprintf(buff, "%s.new", ini->filename);
   	if ((f_new = aca_fileopen(buff, "w", TRUE)) == NULL)
        	return FALSE;
   	
   	fputs("ACAlib's INI-file - Please, not edit this file manually.\n\n", f_new);
   	while(getnext_section(f_old, sname)) {
        	if ((sect = INI_flag_save(ini, sname))) {
   			if (!INI_existData(sect)) 
   				continue;
   			save_sect(f_new, sect);	
   		} else if (! INI_flag_delete(ini, sname)) {
   			fprintf(f_new, "\n\n[%s]\n", sname);	
   			cpy_section(f_old, f_new);
 		}
   	}
   	/* Save new sections */
   	for (sect=ini->section; sect->name != NULL; sect++) {
   		if (sect->flag & SECT_SAVE) {
   			if (!INI_existData(sect))
   				continue;
 			save_sect(f_new, sect);
   		}
   	}
   		
	fclose(f_old);
      	fclose(f_new);	
      	unlink(ini->filename);
      	rename(buff, ini->filename);

      	return TRUE;
   }   
   
   int	INI_existData(INI_Section *sect)
   {
   	INI_SectionData	*sect_d;
   	
   	_D( " INI_existData() ");
   	
   	for(sect_d=sect->data; sect_d->value != NULL; sect_d++) 
   		if (sect_d->content)	
   			return TRUE;
   	return FALSE;
   }
   
   INI_Section *INI_section(aca_INI *ini, char *sectname)
   {
   	INI_Section	*sect;
   	
   	_D( " INI_section()");
   	
   	if (!sectname) return (INI_Section *) NULL;
   	
   	for(sect=ini->section; sect->name != NULL; sect++) 
   		if (!strcmp(sect->name, sectname)) 
   			return sect;
   	return (INI_Section *) NULL;
   }
   
   char *INI_value(INI_Section *s, char *valname)
   {
   	INI_SectionData	*sect_d;
   	
   	_D( " INI_value()");
   	
   	if (!valname) return chN;
   	
   	for(sect_d=s->data; sect_d->value != NULL; sect_d++) 
   		if (!strcmp(sect_d->value, valname)) 
   			return sect_d->content;
   	return chN;
   }


   
   void INI_fprintf(FILE *f, aca_INI *ini)
   {
   	INI_Section	*sect;
   	INI_SectionData	*sect_d;
   	
   	_D(" INI_fprintf()");
   	
   	fprintf(f, "INI Filename:\t%s\n", ini->filename);
   	
   	for(sect=ini->section; sect->name != NULL; sect++) {
   		fprintf(f, "\nSection Name:\t%s\n", sect->name);
   		fputs("Section Flag:\t", f);
   		if (sect->flag & SECT_SAVE)	fputs("SAVE ", 	f);
   		if (sect->flag & SECT_SAVED)	fputs("SAVED ",	f);
   		if (sect->flag & SECT_LOAD)	fputs("LOAD ", 	f);
   		if (sect->flag & SECT_LOADED)	fputs("LOADED ",f);
   		if (sect->flag & SECT_DELETE)	fputs("DELETE ",f);		
   		fputc('\n', f); 
   		for(sect_d=sect->data; sect_d->value != NULL; sect_d++) 
   			fprintf(f, "\t%s:\t%s\n", sect_d->value, sect_d->content);	
   	}
   }

   INI_Section *INI_sect_flag(aca_INI *ini, char *sname, int flag)
   {
      INI_Section	*p;
   
      _D(" INI_sect_flag()");
   
      if (!sname || !ini) return (INI_Section *) NULL;
      
      for (p=ini->section; p->name != NULL; p++) {
         if (!strcmp(p->name, sname)) {
            switch (flag) {
            	case SECT_SAVE:
            		if (p->flag & SECT_SAVE) return p;
            		else return (INI_Section *) NULL;	
            	case SECT_SAVED:
            		if (p->flag & SECT_SAVED) return p;
            		else return (INI_Section *) NULL;		
		case SECT_LOAD:            	
            		if (p->flag & SECT_LOAD) return p;
            		else return (INI_Section *) NULL;			
		case SECT_LOADED:
            		if (p->flag & SECT_LOADED) return p;
            		else return (INI_Section *) NULL;	
            	case SECT_DELETE:
            		if (p->flag & SECT_DELETE) return p;
            		else return (INI_Section *) NULL;		
		default:
			return (INI_Section *) NULL;	
            }
         }
      }
      return (INI_Section *) NULL;	
   }
   
   INI_Section *INI_set_sect_flag(aca_INI *ini, char *sname, int flag, int set)
   {
      INI_Section	*p;
   
      _D(" INI_set_sect_flag()");
   
      if (!sname || !ini) return (INI_Section *) NULL;
   
      for (p=ini->section; p->name != NULL; p++) {
         if (!strcmp(p->name, sname)) {
            switch (flag) {
            	case SECT_SAVE:
            		if (set) { 
            			p->flag |= SECT_SAVE;
            			p->flag &= ~SECT_SAVED;
            			p->flag &= ~SECT_DELETE;
            		} else     
            			p->flag &= ~SECT_SAVE;
            		return p;
		case SECT_LOAD:            	
            		if (set) {
            			p->flag |= SECT_LOAD;
            			p->flag &= ~SECT_LOADED;
            		} else	
            			p->flag &= ~SECT_LOAD;
            		return p;		
          	case SECT_LOADED:
            		if (set) {
            			p->flag |= SECT_LOADED;
            			p->flag &= ~SECT_LOAD;
            		} else     
            			p->flag &= ~SECT_LOADED;
            		return p;
            	case SECT_DELETE:
            		if (set) { 
            			p->flag |= SECT_DELETE;
            			p->flag &= ~SECT_SAVE;
            		} else     
            			p->flag &= ~SECT_DELETE;
            		return p;
            	case SECT_SAVED:
            		if (set) {
            			p->flag |= SECT_SAVED;
            			p->flag &= ~SECT_SAVE;
            		} else
            			p->flag &= ~SECT_SAVED;
            		return p;		
          	default:
			return (INI_Section *) NULL;	
            }
         }
      }
      return (INI_Section *) NULL;	
   }


