/*
 * Copyright (c) 2003 Brian Kreulen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __PLAYLIST_H__
#define __PLAYLIST_H__

#include "filewriter.h"
#include "docwidget.h"

class ArsonPlaylistListItem : public ArsonListItem
{
public:
    ArsonPlaylistListItem (void) : m_songLength(0), ArsonListItem() { }
    ArsonPlaylistListItem (const KURL &url) : ArsonListItem(), m_url(url) { ArsonPlaylistListItem(); }

	virtual QString display (void) const { return m_songName; }
	virtual QString persist (void) const { return m_url.prettyURL(); }

    int songLength (void) { return m_songLength; }
    void setSongLength (int sLength) { m_songLength = sLength; }
    QString songName (void) { return m_songName; }
    void setSongName (const QString &sn) { m_songName = sn; }

    KURL url (void) { return m_url; }

private:
    int m_songLength;
    KURL m_url;
    QString m_songName;
};

/*========================================================*/
/* ========== Mondo Spaghetti Hacking ======================
- ArsonM3UFileWriter is a rewrite of Tony's ArsonM3uFileWriter class, which
 doesn't do what I want to do, but I can't get rid of easily since Arson needs it.
- Also, ArsonFileWriter doesn't support appending since it uses the KIO::network
 API. I had to change ArsonFileWriter to accept a null URL and not copy its temp
 file if this is set. This is ugly and will be changed in the next revision. (Famous last
 words).

TODO:
- Get rid of ArsonM3uFileWriter and put it's "functionality" into here.
- Make a nice virtual ArsonFileWriter which supports appending and
 delegates file opening & writing to subclasses. If this is even possible.
*/

class ArsonM3UFileWriter : public ArsonFileWriter
{
public:
    enum {
        M3uWriter_Append,
        M3uWriter_Overwrite
    };

	ArsonM3UFileWriter (ArsonFileListDoc *pd, const KURL &url, int fileMode, KURL &empty);
    ~ArsonM3UFileWriter ();

	virtual void beginDocument (void);
	virtual bool visit (QListViewItem *pi, ArsonListItem *pl);
    QTextStream &textStream() { return *m_stream; }

private:
    bool verifyDirectory (const QString &dirName);
    void writeM3uLine (const QString &str);

    QFile m_indexFile;
    QTextStream *m_stream;
    int m_fileMode;
};

/*========================================================*/
class ArsonRipperDoc;
class ArsonMp3Doc;

class ArsonPlaylistFileListDoc : public ArsonFileListDoc {
public:
    enum {
        Playlist_Append,
        Playlist_Overwrite
    };

    ArsonPlaylistFileListDoc (QWidget *parent, const char *name = NULL);

    virtual ArsonM3UFileWriter *createM3UFileWriter (const KURL &url, int fileMode);
    virtual ArsonPlaylistListItem *createPlaylistItem (const KURL &url, int length, const QString &name) const;
	virtual void addItem (ArsonPlaylistListItem *ptr, ArsonLvPos *pos = NULL);

	virtual ArsonProcessMgr *createCdWriter (ArsonProcessUI *pUI) { return 0;}
	virtual ArsonProgress *createProgress (QWidget *parent) { return 0; }
	virtual bool saveDocument (const KURL &url);

    void importRipperFileListDoc (ArsonRipperDoc *pflDoc);
    void importMp3ListDoc (ArsonMp3Doc *pflDoc);
    
    void setFileMode (int fileMode) { m_fileMode = fileMode; }

private:
    int m_fileMode;
};

#endif	/*	__PLAYLIST_H__	*/
