// Interp.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef INTERP_H
#define INTERP_H

#ifdef MULTITHREAD
#include <pthread.h>
#endif

#include "Bot.H"
#include "ScriptCommands.H"
#include <libguile.h>

struct wrapper_data {
  SCM func;
  SCM args;
};

SCM gh_apply_wrapper(void *);

class Interp {
public:
  static Bot *bot;
#ifdef MULTITHREAD
private:
  static pthread_mutex_t mutex;
#endif
public:
  static void Startup();
  static void Shutdown();
  static void Execute(Bot *, String);
  static void LoadScript(Bot *, String);
  static SCM ErrorHandler(void *, SCM, SCM);
};

#endif
