/* Slightly more intelligent configuration dialog */

#include <qlineedit.h>
#include <qbutton.h>
#include <qbuttongroup.h>
#include <qcolordialog.h>
#include <qcheckbox.h>
#include <qfontdialog.h>
#include <qspinbox.h>

#include "SnapshotSettingsDlg.h"
#include "CamStreamApp.h"

CSnapshotSettingsDlg::CSnapshotSettingsDlg(struct SVideoOptions *opts)
{
   int i, m, mask, set;
   QButton *pButton;
   QString fm;

qDebug("CSnapshotSettingsDlg::CSnapshotSettingsDlg(...)");
   pVOpts = opts;
   BaseName->setText(pVOpts->GetBaseName());
   TextColor = pVOpts->GetTextColor();   
   TextFont = pVOpts->GetTextFont();
   TimestampImage->setChecked(pVOpts->GetTimeInImage());
   FileFormat = pVOpts->GetFileFormat();
   SaveToDisk->setChecked(pVOpts->GetSaveToDisk());
   FTPToServer->setChecked(pVOpts->GetFTPToServer());
   SaveOption->setButton(pVOpts->GetSaveOption());
   MaxSequence->setValue(pVOpts->GetMaxSequence());

   m = CamApp->GetNumberOfFileTypes();
   mask = CamApp->GetFileTypeMask();
//qDebug("Mask = 0x%02x", mask);
   set = -1;

   /* Loop through the file formats, set the textlabels on the radio
      buttons, and enable the buttons that we support. Black out superfluous
      radio buttons. In addition, preset the button with the format we
      selected last time (if any).
    */
   for (i = 0; i < 16; i++) {
      pButton = SelectedFormat->find(i);
      if (pButton) {
        if (i < m) {
          fm = CamApp->GetFileTypeFormatStr(i);
          pButton->setText(fm);
          if (mask & (1 << i)) {
            pButton->setEnabled(TRUE);
            if (fm == FileFormat)
              set = i;
          }
          else
            pButton->setEnabled(FALSE);
        }
        else
          pButton->hide();
      }
   }
   if (set == -1) {
     // Hmm... the previously selected format is not available.. choose one
     for (set = 0; set < m; set++) {
        if (mask & (1 << set)) {
          pVOpts->SetFileFormat(CamApp->GetFileTypeFormatStr(set));
          break;
        }
     }
   }
   SelectedFormat->setButton(set);
   
   pFTPSettings = new CFTPSettings(0, 0, TRUE);
   pFTPSettings->Hostname->setText(pVOpts->GetFTPServer());
   pFTPSettings->Path->setText(pVOpts->GetFTPPath());
   pFTPSettings->Username->setText(pVOpts->GetFTPUser());
   pFTPSettings->Password->setText(pVOpts->GetFTPPass());
   pFTPSettings->m_Passive->setChecked(pVOpts->GetFTPPassive());
   pFTPSettings->m_Unique->setChecked(pVOpts->GetFTPUnique());
}


void CSnapshotSettingsDlg::ClickedOK()
{
qDebug("CSnapshotSettingsDlg::ClickedOK()");
   // Stuff options back into SVideoOptions
   pVOpts->SetBaseName(BaseName->text());
   pVOpts->SetTextColor(TextColor);
   pVOpts->SetTextFont(TextFont);
   pVOpts->SetTimeInImage(TimestampImage->isChecked());
   pVOpts->SetFileFormat(SelectedFormat->selected()->text());
   pVOpts->SetSaveToDisk(SaveToDisk->isChecked());
   pVOpts->SetFTPToServer(FTPToServer->isChecked());
   pVOpts->SetSaveOption(SaveOption->id(SaveOption->selected()));
   pVOpts->SetMaxSequence(MaxSequence->value());
}

void CSnapshotSettingsDlg::ClickedColor()
{
   QColor c;

qDebug("CSnapshotSettingsDlg::ClickedColor()");
   c = QColorDialog::getColor(TextColor, this);
   if (c.isValid())
     TextColor = c;
}

void CSnapshotSettingsDlg::ClickedFont()
{
   bool ok;
   QFont f;
   
qDebug("CSnapshotSettingsDlg::ClickedFont()");
   f = QFontDialog::getFont(&ok, TextFont, this);
   if (ok)
     TextFont = f;
}

void CSnapshotSettingsDlg::ClickedFTP()
{
   int result;
   
   result = pFTPSettings->exec();
   if (result == QDialog::Accepted) {
     qDebug("Setting FTP values");   
     pVOpts->SetFTPServer(pFTPSettings->Hostname->text());
     pVOpts->SetFTPPath(pFTPSettings->Path->text());
     pVOpts->SetFTPUser(pFTPSettings->Username->text());
     pVOpts->SetFTPPass(pFTPSettings->Password->text());
     emit FTPSettingsUpdated();
   }
}
