/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * macro.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: macro.h,v 1.1 2004/01/13 18:10:29 ericprev Exp $
*/

#ifndef __MACRO_H__
#define __MACRO_H__

/****************************************************************************************************************/
/* same as gtk_tree_view_insert_column_with_attributes except but the created column is resizable and clickable */
/****************************************************************************************************************/
#define MY_RS_gtk_tree_view_insert_column_with_attributes(view,num_col,attributes...)	\
	{																											\
		GtkTreeViewColumn *MYcol;																		\
		MYcol=gtk_tree_view_column_new_with_attributes(attributes);							\
		gtk_tree_view_column_set_resizable(MYcol,TRUE);											\
		gtk_tree_view_column_set_sort_column_id(MYcol,num_col);								\
		gtk_tree_view_insert_column(view,MYcol,num_col);										\
	}

/****************************************************************************************************************/
/* same as gtk_tree_view_insert_column_with_attributes except but the created column is resizable and clickable */
/* the column is inserted at the position num_col and sorted on num_sort_col                                    */
/****************************************************************************************************************/
#define MY_RS2_gtk_tree_view_insert_column_with_attributes(view,num_col,num_sort_col,attributes...)	\
	{																											\
		GtkTreeViewColumn *MYcol;																		\
		MYcol=gtk_tree_view_column_new_with_attributes(attributes);							\
		gtk_tree_view_column_set_resizable(MYcol,TRUE);											\
		gtk_tree_view_column_set_sort_column_id(MYcol,num_sort_col);						\
		gtk_tree_view_insert_column(view,MYcol,num_col);										\
	}

/**************************************************************************************************/
/* same as gtk_tree_view_insert_column_with_attributes except but the created column is clickable */
/**************************************************************************************************/
#define MY_gtk_tree_view_insert_column_with_attributes(view,num_col,attributes...)	\
	{																											\
		GtkTreeViewColumn *MYcol;																		\
		MYcol=gtk_tree_view_column_new_with_attributes(attributes);							\
		gtk_tree_view_column_set_sort_column_id(MYcol,num_col);								\
		gtk_tree_view_insert_column(view,MYcol,num_col);										\
	}

/****************************************************************************************************************/
/* same as gtk_tree_view_insert_column_with_attributes except but the created column is resizable and clickable */
/* a user fnc and a user parameter are called when the column is clicked.                                       */
/****************************************************************************************************************/
#define MY_RS_CK_gtk_tree_view_insert_column_with_attributes(view,user_fnc,num_col,attributes...)	\
	{																											\
		GtkTreeViewColumn *MYcol;																		\
		MYcol=gtk_tree_view_column_new_with_attributes(attributes);							\
		gtk_tree_view_column_set_resizable(MYcol,TRUE);											\
		gtk_tree_view_column_set_sort_column_id(MYcol,num_col);								\
		gtk_tree_view_insert_column(view,MYcol,num_col);										\
		g_signal_connect((gpointer)MYcol,"clicked",G_CALLBACK(user_fnc),GINT_TO_POINTER(num_col));\
	}


#endif
