/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * typical_action.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: typical_action.h,v 1.4 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __TYPICAL_ACTION_H__
#define __TYPICAL_ACTION_H__

/*********************************************************************/
/* setup our info on hub                                             */
/* string format:  $MyINFO $ALL nickname aaa$ $xxxf$bbb$yyy$         */
/*       aaa is user description                                     */
/*			xxx is connection type (ex: Cable)                          */
/*       f is a 1 byte flag. Default value: \x01                     */
/*             if not behind firewall, bit 1 must be set, else clear */
/*			bbb is e-mail (empty string)                                */
/*			yyy is size of shared data in bytes                         */
/*********************************************************************/
/* Note: the function may automatically add a TAG to the MyINFO */
/****************************************************************/
void set_user_info(int sck,char *nick, char *description, char *cnx,char c_opt,char *mail,double amount);

/****************************************************************/
/* this function must be called when the client is disconnected */
/* the hub to be sure when it re-enters, it sends its my info   */
/****************************************************************/
void reset_last_myinfo(void);

#endif
