/* $Id: AttrDefs.c,v 1.3 2000/07/17 14:16:58 peter Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "AttrDefs.h"
#include "GlobDef.h"
#include "LIGA.h"
#include "LIGAMacros.h"
#include "ligaconsts.h"
#include "pdl_gen.h"
#include "msgtxt.h"
static POSITION nullpos;

int GenAttrId;

static int AttrSymbCombCnt = 1;

void NewSymCompNo (k) DefTableKey k;
{
SetAttrSymCompNo (k, AttrSymbCombCnt++, MultipleSymComp);
}

static void InitAttr (k, kd, tp, cl, prod, pos)
	DefTableKey	k;
	int		kd, tp, cl, prod;
	POSITION	*pos;
{	int	did;

did = GenDid ();
ResetDid (k, did);
ResetCoord (k, pos);
ResetAttrKind (k, kd);
ResetAttrProdDid (k, prod);
if (tp != DIDNON) ResetAttrType (k, tp);
ResetAttrClass (k, cl);
}/* InitAttr */

void UpdateClass (k, cl, pos)
	DefTableKey		k;
	int		cl;
	POSITION *	pos;
{	int		oldcl;
if (cl != ATCLUNKN) {
	oldcl = GetAttrClass (k, ATCLUNKN);
	if (oldcl == ATCLUNKN)
		ResetAttrClass (k, cl);
	else if (oldcl != cl)
		message (FATAL, MSGTXT("Attribute class in conflict",(lidoref)Types and Classes of Attributes), 0, pos);
}}/* UpdateClass */

void UpdateType (k, tp, pos)
	DefTableKey		k;
	int		tp;
	POSITION *	pos;
{	int		oldtp;
if (tp != DIDNON) {
	oldtp = GetAttrType (k, DIDNON);
	if (oldtp == DIDNON)
		ResetAttrType (k, tp);
	else if (oldtp != tp)
		message (ERROR,
			MSGTXT("Different attribute types specified",(lidoref)Types and Classes of Attributes), 0, pos);
}}/* UpdateType */

DefTableKey DeclareAttrName (scope, id, kd, tp, cl, pos)
	Environment	scope;
	int		id, kd, tp, cl;
	POSITION *	pos;
/*
On Exit:
	scope has an entry for the attribute name or chain name id.
	The kind (Attr, Chain), type, and class are set if they do
	not conflict with an already existing entry.
*/
{	DefTableKey		k;
	

if (scope == NoEnv)
	message (DEADLY, MSGTXT("Internal error: AttrDefs ",(help)system), 8, pos);
k = DefineIdn (scope, id);

if (DIDNON == GetDid (k, DIDNON))
	InitAttr (k, kd, tp, cl, DIDNON, pos);
else
if (kd == GetAttrKind (k, kd)) {
	UpdateClass (k, cl, pos);
	UpdateType (k, tp, pos);
}
else
	ResetAttrKind (k, isMultiAttr);

return (k);
}/* DeclareAttrName */

Environment AttrNameEnv = NoEnv; /* exported */

Environment AttrPreDefs ()
{	Environment	e;
	int		idtoken = 4; /* token class is not relevant here */

e = NewEnv ();
AttrNameEnv = e; /* exported */

nullpos.line = 0;
nullpos.col = 0;

mkidn(GENTREEATTR, strlen (GENTREEATTR), &idtoken, &GenAttrId);
(void) DeclareAttrName (e, GenAttrId, isAttrName, DIDNODE, ATCLINH, &nullpos);
return (e);
}/*AttrPreDefs*/


DefTableKey DeclareExplAttr (scope, id, tp, cl, pos)
	Environment	scope;
	int		id, tp, cl;
	POSITION *	pos;
/*
On Exit:
	scope has an entry for the attribute id, the key is returned,
	class and type are set if they do not
	not conflict with an already existing entry.
	no chain check here!
*/
{	DefTableKey		k;

k = DefineIdn (scope, id);

if (DIDNON == GetDid (k, DIDNON))
	InitAttr (k, isSymbAttr, tp, cl, DIDNON, pos);	
else {
	UpdateClass (k, cl, pos);
	UpdateType (k, tp, pos);
} 
return (k);
}/* DeclareExplAttr */


void MultDeclareExplAttr (symkeys, attrid, typeid, class, pos)
	TList	symkeys;
	int	attrid, typeid, class;
	POSITION *	pos;
/*
	DeclareExplAttr applied to each of the symkeys.
*/
{	DefTableKey		ak;
	Environment	scope;
	int		kind;

if (symkeys == NullList) 
	message (DEADLY, MSGTXT("Internal error: AttrDefs ",(help)system), 1, pos);
scope = GetAttrScope ((DefTableKey)HeadList (symkeys), NoEnv);
if (scope == NoEnv)
	message (DEADLY, MSGTXT("Internal error: AttrDefs ",
                                 (help)system), 
                 2, pos);

if (attrid == GenAttrId) {
	message (ERROR, MSGTXT("Predefined name GENTREE is not allowed",
                                (lidoref)Computed Subtrees),
		0, pos);
	return;
}

ak = KeyInEnv (scope, attrid);
kind = GetAttrKind (ak, isSymbAttr);

if (kind == isChainAttr) {
	message (ERROR, MSGTXT("Attribute name clashes with CHAIN name",
                               (lidoref)CHAIN), 
		 0, pos);
	return;
}

while (symkeys != NullList) {
	scope = GetAttrScope ((DefTableKey)HeadList (symkeys), NoEnv);
	if (scope == NoEnv)
		message (DEADLY, MSGTXT("Internal error: AttrDefs ",
					(help)system), 
			 3, pos);
	DeclareExplAttr (scope, attrid, typeid, class, pos);
	symkeys = TailList (symkeys);
}
}/* MultDeclareExplAttr */


DefTableKey DeclareImplAttr (symkey, id, cl, pos)
	DefTableKey	symkey;
        int             id, cl;
        POSITION *      pos;
/*
On Exit:
	the key of an attr id for symkey is returned,
	the class is set if it does
	not conflict with an already existing entry.
	no chain check here!
*/
{	DefTableKey	k;
	int		kind;
	int		globtp, globcl;
        Environment	scope;

if ((symkey == SYNTKey) || (symkey == INHKey) || (symkey == THISKey)) {
	return (NoKey); /* caller supplies symkey or indicates error
				in case of SYNTKey INHKey THISKey */
}

scope = GetAttrScope (symkey, NoEnv);
k = KeyInEnv (scope, id);	

if (k == NoKey) {
	k = DefineIdn (scope, id);
	InitAttr (k, isSymbAttr, DIDNON, cl, DIDNON, pos);
} else {
	kind = GetAttrKind (k, isSymbAttr);
	switch (kind) {
	case isAttrName:
/* attr is not yet defined for this symbol;
   define it but don't take properties from ATTR name;
   they may come from inheritance
*/
		k = DefineIdn (scope, id);
		InitAttr (k, isSymbAttr, DIDNON, cl, DIDNON, pos);
		break;
	case isSymbAttr:
		UpdateClass (k, cl, pos);
		break;
	default:;
	}
}
return (k);
}/* DeclareImplAttr */
 
DefTableKey DeclareLocAttr (symkey, id, prodid, namescope, pos)
	DefTableKey		symkey;
	int		id, prodid;
	Environment	namescope;
	POSITION	*pos;
{	DefTableKey		k, namekey;
	int		newid, globtp;
	Environment	scope;

namekey = KeyInEnv (namescope, id);
if (namekey == NoKey)
	globtp = DIDVOID;
else	globtp = GetAttrType (namekey, DIDNON);

scope = GetAttrScope (symkey, NoEnv);
if (scope == NoEnv)
	message (DEADLY, MSGTXT("Internal error: AttrDefs ",
				(help)system), 6, pos);

newid = NumToIdn (id, prodid);

k = KeyInScope (scope, newid);

if (k == NoKey) {
	k = DefineIdn (scope, newid);
	InitAttr (k, isLocAttr, globtp, ATCLSYNT, prodid, pos);
} else if (isLocAttr != GetAttrKind (k, isLocAttr))
		message (ERROR, MSGTXT("Different attribute classes",
				       (lidoref)Types and Classes of Attributes), 
			 0, pos);
return (k);
}/*DeclareLocAttr*/


