# Copyright (C) 2002-2004 Ghostgum Software Pty Ltd.  All rights reserved.
#
#  This software is provided AS-IS with no warranty, either express or
#  implied.
#
#  This software is distributed under licence and may not be copied,
#  modified or distributed except as expressly authorised under the terms
#  of the licence contained in the file LICENCE in this distribution.
#
#  For more information about licensing, please refer to
#  http://www.ghostgum.com.au/ or contact Ghostsgum Software Pty Ltd, 
#  218 Gallaghers Rd, Glen Waverley VIC 3150, AUSTRALIA, 
#  Fax +61 3 9886 6616.
#

# $Id: epstool.mak,v 1.3 2004/11/28 01:02:47 ghostgum Exp $
# Make epstool for GNU/Linux

BINDIR=./bin
OBJDIR=./epsobj
SRCDIR=./src
SRCWINDIR=./srcwin

XINCLUDE=
PFLAGS=
PLINK=

GTKCFLAGS=
GTKLIBS=

LIBPNGINC=
LIBPNGCFLAGS=
LIBPNGLIBS=

EPSTOOL_ROOT=/usr/local
EPSTOOL_BASE=$(prefix)$(EPSTOOL_ROOT)
EPSTOOL_BINDIR=$(EPSTOOL_BASE)/bin
EPSTOOL_MANDIR=$(EPSTOOL_BASE)/man
EPSTOOL_DOCDIR=$(EPSTOOL_BASE)/share/doc

LONGFILEDEF=
LONGFILEMOD=cfile

include $(SRCDIR)/unixcom.mak

EPSOBJPLAT=$(OD)xnodll$(OBJ) $(OD)$(LONGFILEMOD)$(OBJ)
EPSLIB=$(LIBPNGLIBS)

BEGIN=$(OD)lib.rsp
TARGET=epstool

include $(SRCDIR)/common.mak

epstool: $(BD)epstool$(EXE)

$(OD)lib.rsp: makefile
	-mkdir $(BINDIR)
	-mkdir $(OBJDIR)
	echo "dummy" > $(OD)lib.rsp

install: $(TARGET)
	-mkdir -p $(EPSTOOL_BASE)
	chmod a+r $(EPSTOOL_BASE)
	-mkdir -p $(EPSTOOL_BINDIR)
	chmod a+r $(EPSTOOL_BINDIR)
	$(INSTALL_EXE) $(BD)epstool$(EXE) $(EPSTOOL_BINDIR)$(DD)epstool$(EXE)
	-mkdir -p $(EPSTOOL_MANDIR)
	chmod a+r $(EPSTOOL_MANDIR)
	-mkdir -p $(EPSTOOL_MANDIR)$(DD)man1
	chmod a+r $(EPSTOOL_MANDIR)$(DD)man1
	$(INSTALL) doc$(DD)epstool.1 $(EPSTOOL_MANDIR)$(DD)man1$(DD)epstool.1
	-mkdir -p $(EPSTOOL_DOCDIR)
	chmod a+r $(EPSTOOL_DOCDIR)
	$(INSTALL) doc$(DD)epstool.htm $(EPSTOOL_DOCDIR)$(DD)epstool.htm
	$(INSTALL) LICENCE $(EPSTOOL_DOCDIR)$(DD)LICENCE


clean:
	-$(RM) $(EPSOBJS)
	-$(RM) $(OD)lib.rsp
	-$(RM) $(BD)epstool$(EXE)
	-rmdir $(OBJDIR)

