/*
 * (C) Copyright IBM Corp. 2001, 2003
 *
 * This program is free software;  you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;  if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: plugins/bbr_seg/bbr_seg.h
 */

#ifndef BAD_BLOCK_RELOCATION_HEADER
#define BAD_BLOCK_RELOCATION_HEADER

#define EVMS_BBR_FEATURE_ID		6
#define EVMS_BBR_SIGNATURE		0x42627253   /* BbrS */

#define BBR_ENABLED			0x1
#define BBR_CHANGE_STATE		0x2
#define BBR_ACTIVATE			0x4

#define BBR_FUNCTION_ENABLE		(EVMS_Task_Plugin_Function + 0)
#define BBR_FUNCTION_DISABLE		(EVMS_Task_Plugin_Function + 1)

/* The following defines establish the minimum and maximum number of
 * replacement sectors which can be allocated for Bad Block Relocation.
 * Otherwise, 1 replacement sector per MB of disk space is allocated.
 */
#define EVMS_BBR_ENTRIES_PER_SECT	31 /* Assume sector size is 512 bytes*/

#define EVMS_BBR_TABLE_SIGNATURE	0x42627254 /* BbrT */

/* Minimum number of replacement blocks to
 * use for a partition (roughly 2 tracks).
 */
#define BBR_MIN_REPLACEMENT_BLOCKS	128

/* Maximum number of replacement blocks to
 * use for a partition (roughly 65 tracks).
 */
#define BBR_MAX_REPLACEMENT_BLOCKS	2048

#define SECTOR_IO_READ			0
#define SECTOR_IO_WRITE			1

extern plugin_record_t			*my_plugin_record;
extern engine_functions_t		*EngFncs;

/**
 * struct evms_bbr_table_entry
 **/
typedef struct evms_bbr_table_entry {
	u_int64_t bad_sect;
	u_int64_t replacement_sect;
} evms_bbr_table_entry_t;

/**
 * struct evms_bbr_table
 * @signature: Signature for a sector of the bbr table (EVMS_BBR_TABLE_SIGNATURE)
 * @crc: CRC for this sector of the BBR Table.
 * @sequence_number: Used to resolve conflicts when the primary and secondary tables do not match.
 * @in_use_cnt: Number of in-use entries.
 * @entries: BBR table entries available for this sector of the BBR table.
 **/
typedef struct evms_bbr_table {
	u_int32_t		signature;
	u_int32_t		crc;
	u_int32_t		sequence_number;
	u_int32_t		in_use_cnt;
	evms_bbr_table_entry_t	entries[EVMS_BBR_ENTRIES_PER_SECT];
} evms_bbr_table_t;

/**
 * struct evms_bbr_metadata
 * @signature: EVMS_BBR_SIGNATURE
 * @crc:
 * @block_size: block size in bytes.
 * @flags: Global flag used by BBR.
 * @sequence_number:
 * @start_sect_bbr_table: Start 64-bit LBA of the BBR table.
 * @nr_sects_bbr_table: Number of sectors to hold the BBR table.
 * @start_replacement_blks: Start 64-bit LBA of the replacement sectors.
 * @nr_replacement_blks: Number of replacement blocks.
 * @bbr_active:
 * @uuid:
 * @pad1:
 * @data_start:
 * @data_size:
 * @pad2:
 *
 * Description of on disk meta data sector for bbr feature.
 **/
typedef struct evms_bbr_metadata {
/* 0*/	u_int32_t	signature;
/* 4*/	u_int32_t	crc;
/* 8*/	u_int32_t	block_size;
/*12*/	u_int32_t	flags;
/*16*/	u_int64_t	sequence_number;
/*24*/	u_int64_t	start_sect_bbr_table;
/*32*/	u_int64_t	nr_sects_bbr_table;
/*40*/	u_int64_t	start_replacement_sect;
/*48*/	u_int64_t	nr_replacement_blks;
/*56*/	u_int32_t	bbr_active;
/*60*/	char		uuid[EVMS_NAME_SIZE+1];
/*188*/	u_int32_t	pad1;
/*192*/	u_int64_t	data_start;
/*200*/	u_int64_t	data_size;
/*208*/	char		pad2[302];
/*510*/ /* I know, this isn't 512 bytes. Don't worry. */
} evms_bbr_metadata_t;

/**
 * guid_t
 * @time_low: Timestamp - low order 32 bits
 * @time_mid: Timestamp - mid 16 bits
 * @time_high: Timestamp - high 16 bits
 * @clock_seq_high: Clock - high order 8 bits
 * @clock_seq_low: Clock - low order 8 bits
 * @node: Spatial reference - unique identification like
 *        the mac address of this systems network card.
 **/
typedef struct _guid_s {
	u_int32_t	time_low;
	u_int16_t	time_mid;
	u_int16_t	time_high;
	u_int8_t	clock_seq_high;
	u_int8_t	clock_seq_low;
	u_int8_t	node[6];
} __attribute__((packed)) guid_t;

typedef struct kill_sectors_s {
	lsn_t			lsn;
	sector_count_t		count;
	struct kill_sectors_s	*next;
} kill_sectors_t;

/**
 * struct bbr_private_data
 *
 * @signature: Private data can be verified by this signature.
 * @child: Child object that we consumed.
 * @replacement_blocks_lsn: Replacement blocks information
 * @replacement_blocks_needed:
 * @replacement_blocks_size_in_sectors:
 * @bbr_table_lsn1: BBR1 bable information
 * @bbr_table_lsn2:
 * @bbr_table_size_in_sectors:
 * @bbr_table: Block size
 * @sequence_number: Feature data information
 * @block_size:
 * @bbr_state: Disabled or enabled, change
 * @kill_sector_list_head:
 * @old_size: Save the old segment size following an expand or shrink.
 *
 * BBR storage object private data area
 **/
typedef struct bbr_private_data {
	u_int32_t		signature;
	storage_object_t	*child;
	u_int64_t		replacement_blocks_lsn;
	u_int64_t		replacement_blocks_needed;
	u_int64_t		replacement_blocks_size_in_sectors;
	u_int64_t		bbr_table_lsn1;
	u_int64_t		bbr_table_lsn2;
	u_int64_t		bbr_table_size_in_sectors;
	evms_bbr_table_t	*bbr_table;
	u_int64_t		sequence_number;
	u_int32_t		block_size;
	u_int32_t		bbr_state;
	kill_sectors_t		*kill_sector_list_head;
	u_int64_t		old_size;
} bbr_private_data_t;

#endif

