pid_t start_fdserver(char *control_file)
{
  pid_t fresult=fork();
  if (fresult) {
    int len=strlen(control_file);
    char *dirname=strdup(control_file), *scan=dirname+len-1;
    while ((scan >= dirname) && (*scan != '/')) scan--; *scan=NUL;
    chdir(dirname); exec("fdserver",control_file);}
  else return fresult;
}

struct SERVER_ENTRY {
  char *control_file, *dirname;
  pid_t pid;};

int main(int argc,char *argv[])
{
  char *control_files[]=malloc(sizeof(char *)*256); char buf[256];
  int i=0, n_control_files, max_control_files, status;
  FILE *f=fopen(argv[1],"r");
  pid_t proc;
  if (f == NULL) {
    fprintf(stderr,"the master list of control files (%s) does not exist\n",
	    argv[1]);
    exit(1);}
  while (fgets(buf,256,f)) {
    if (n_control_files+1 == max_control_files) {
      control_files=realloc(control_files,sizeof(char *)*(max_control_files+256));
      max_control_files=max_control_files+256;}
    control_files[n_control_files].file=strdup(buf);
    control_files[n_control_files].dir=get_dirname(buf);
    control_files[n_control_files].pid=start_server(&(control_files[i]));}
  while (proc=wait(&status)) {
    int j=0; while (j < n_control_files)
      if (control_files[j].pid == proc) break; else j++;
    control_files[j].pid=start_server(&(control_files[j]));}
}
