/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: utils.h,v 1.22 2004/06/13 07:45:51 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef  __UTILS_H_
#define  __UTILS_H_


#include <string>
#include <list>
#include <functional>

class QObject;
class QWidget;
class QPopupMenu;
class QComboBox;
class QListBox;

#include <qkeysequence.h>
#include <qstring.h>
#include <qmap.h>

#include "fwbuilder/FWObject.h"

struct FWObjectNameCmpPredicate :
    public std::binary_function<libfwbuilder::FWObject*, libfwbuilder::FWObject*, bool>
{
    bool operator()(libfwbuilder::FWObject *a,libfwbuilder::FWObject *b)
    {
        return a->getName() < b->getName();
    }
};


extern void addPopupMenuItem(QObject *res,
                             QPopupMenu* menu,
                             const QString &resourceIconPath,
                             const char* itemName,
                             const char* member,
                             const QKeySequence &accel = 0);

extern void fillLibraries(QComboBox *libs, libfwbuilder::FWObject *obj, bool rw=false);
extern void fillLibraries(QListBox *libs, libfwbuilder::FWObject *obj, bool rw=false);


/**
 * this is a convenience method that checks if the object tree is
 * read-only and shows appropriate error dialog. This method is
 * there so we don't have to repeat the same code in each object
 * class dialog.
 */

extern bool isTreeReadWrite(QWidget *parent, libfwbuilder::FWObject *obj);

/**
 * this function checks if the name of the object 'obj' is a duplicate
 * by scanning all children objects of its parent and comparing their
 * names. It shows pop-up dialog letting user know if the same name
 * was found, and returns false. It returns true otherwise.
 */
extern bool validateName(QWidget *parent,
                         libfwbuilder::FWObject *obj,
                         const QString &newname);

/**
 * returns a copy of the string str, enclosed in quotes if it contains
 * whitespaces
 */
extern QString quoteString(const QString &str);

extern QString getUserName();
extern QString getFileDir(const QString &file);

/*
 * convenience method that calls Resourcess::getPlatforms() and
 * converts the result to QMap<QString,QString>
 */
extern QMap<QString,QString> getAllPlatforms();

extern QMap<QString,QString> getAllOS();

extern QString readPlatform(QComboBox *platform);
extern QString readHostOS(QComboBox *hostOS);

extern void setPlatform(QComboBox *platform,const QString &pl);
extern void setHostOS(QComboBox *hostOS,const QString &os);

extern void findFirewalls(libfwbuilder::FWObject *o,
                          std::list<libfwbuilder::FWObject*> &fwlist);

extern void findHosts(libfwbuilder::FWObject *o,
                      std::list<libfwbuilder::FWObject*> &fwlist);

extern void findByObjectType(libfwbuilder::FWObject *o,
                             const std::string &otype,
                             std::list<libfwbuilder::FWObject*> &fwlist);

extern void setDisabledPalette(QWidget *w);

extern QString getAddrByName(const QString &name);

#endif
