/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  texttagsignals.cc - Gtk::TextTag and Gtk::TextTagTable virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "texttag.hh"
#include "texttagsignals.hh"
#include "textiter.hh"
#include "private/texttagclass.hh"
#include "../gdk/events.hh"

using namespace GFC;

/*  Gtk::TextTagSignals
 */

Gtk::TextTagSignals::TextTagSignals(TextTag *tag)
: G::ObjectSignals(tag)
{
	Gtk::TextTagClass::init(GTK_TEXT_TAG_GET_CLASS(tag->gtk_text_tag()));
}

Gtk::TextTagSignals::~TextTagSignals()
{
}

bool
Gtk::TextTagSignals::on_event(G::Object& event_object, Gdk::Event& event, const TextIter& iter)
{
	GtkTextTagClass *g_class = TextTagClass::get_parent_class(instance_);
	bool result = false;
	if (g_class->event)
		result = g_class->event((GtkTextTag*)instance_, event_object.g_object(), event.gdk_event(), iter.gtk_text_iter());
	return result;
}

/*  Gtk::TextTagClass
 */

void
Gtk::TextTagClass::init(GtkTextTagClass *g_class)
{
	g_class->event = &event_proxy;
}

GtkTextTagClass*
Gtk::TextTagClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TEXT_TAG_GET_CLASS(instance));
	return static_cast<GtkTextTagClass*>(ptr);
}

GType
Gtk::TextTagClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TEXT_TAG);
	}
	return type;
}

void*
Gtk::TextTagClass::create(const char *name)
{
	return g_object_new(get_type(), "name", name, 0);
}

gboolean
Gtk::TextTagClass::event_proxy(GtkTextTag *tag, GObject *event_object, GdkEvent *event, const GtkTextIter *iter)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)tag, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = G::Object::wrap<G::Object>(event_object);
		Gdk::Event tmp_event(event);
		TextIter tmp_iter(const_cast<GtkTextIter*>(iter));
		result = static_cast<TextTagSignals*>(ptr)->on_event(*object, tmp_event, tmp_iter);
	}
	else
	{
		GtkTextTagClass *g_class = TextTagClass::get_parent_class(tag);
		if (g_class->event)
			result = g_class->event(tag, event_object, event, iter);
	}
	return result;
}

/*  Gtk::TextTagTableSignals
 */

Gtk::TextTagTableSignals::TextTagTableSignals(TextTagTable *table)
: G::ObjectSignals(table)
{
	Gtk::TextTagTableClass::init(GTK_TEXT_TAG_TABLE_GET_CLASS(table->gtk_text_tag_table()));
}

Gtk::TextTagTableSignals::~TextTagTableSignals()
{
}
	
void
Gtk::TextTagTableSignals::on_tag_changed(TextTag& tag, bool size_changed)
{
	GtkTextTagTableClass *g_class = TextTagTableClass::get_parent_class(instance_);
	if (g_class->tag_changed)
		g_class->tag_changed((GtkTextTagTable*)instance_, tag.gtk_text_tag(), size_changed);
}

void
Gtk::TextTagTableSignals::on_tag_added(TextTag& tag)
{
	GtkTextTagTableClass *g_class = TextTagTableClass::get_parent_class(instance_);
	if (g_class->tag_added)
		g_class->tag_added((GtkTextTagTable*)instance_, tag.gtk_text_tag());
}

void
Gtk::TextTagTableSignals::on_tag_removed(TextTag& tag)
{
	GtkTextTagTableClass *g_class = TextTagTableClass::get_parent_class(instance_);
	if (g_class->tag_removed)
		g_class->tag_removed((GtkTextTagTable*)instance_, tag.gtk_text_tag());
}

/*  Gtk::TextTagTableClass
 */

void
Gtk::TextTagTableClass::init(GtkTextTagTableClass *g_class)
{
	g_class->tag_changed = &tag_changed_proxy;
	g_class->tag_added = &tag_added_proxy;
	g_class->tag_removed = &tag_removed_proxy;
}

GtkTextTagTableClass*
Gtk::TextTagTableClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TEXT_TAG_TABLE_GET_CLASS(instance));
	return static_cast<GtkTextTagTableClass*>(ptr);
}

GType
Gtk::TextTagTableClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TEXT_TAG_TABLE);
	}
	return type;
}

void*
Gtk::TextTagTableClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::TextTagTableClass::tag_changed_proxy(GtkTextTagTable *table, GtkTextTag *tag, gboolean size_changed)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextTagTableSignals*>(ptr)->on_tag_changed(*G::Object::wrap<Gtk::TextTag>(tag), size_changed);
	else
	{
		GtkTextTagTableClass *g_class = TextTagTableClass::get_parent_class(table);
		if (g_class->tag_changed)
			g_class->tag_changed(table, tag, size_changed);
	}
}

void
Gtk::TextTagTableClass::tag_added_proxy(GtkTextTagTable *table, GtkTextTag *tag)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextTagTableSignals*>(ptr)->on_tag_added(*G::Object::wrap<Gtk::TextTag>(tag));
	else
	{
		GtkTextTagTableClass *g_class = TextTagTableClass::get_parent_class(table);
		if (g_class->tag_added)
			g_class->tag_added(table, tag);
	}
}

void
Gtk::TextTagTableClass::tag_removed_proxy(GtkTextTagTable *table, GtkTextTag *tag)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextTagTableSignals*>(ptr)->on_tag_removed(*G::Object::wrap<Gtk::TextTag>(tag));
	else
	{
		GtkTextTagTableClass *g_class = TextTagTableClass::get_parent_class(table);
		if (g_class->tag_removed)
			g_class->tag_removed(table, tag);
	}
}

