module CmdLine (initialize,cmdline) where

#if USE_READLINE

import Readline	(initialize, readline, addHistory)
import Char	(isSpace)
import Monad	(when)

cmdline :: String -> IO String
cmdline prompt = do
    ms <- Readline.readline prompt
    case ms of
        Nothing -> return ""
        Just s  -> do when (not (all isSpace s)) (Readline.addHistory s) 
                      return s

#else

import IO (hFlush,stdout)

initialize :: IO ()
initialize = return ()

cmdline :: String -> IO String
cmdline prompt = do putStr prompt; hFlush stdout; getLine

#endif
