#ifndef _FILE_C
#define _FILE_C

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#ifndef FAILURE
#define FAILURE exit(1)
#endif

int 
file_exists_p ( const char *filename )
{
  struct stat buf ;
  int err = stat ( filename , &buf ) ;
  return err == 0 ;
}

#define GENERATE_STAT_FIELD(type,name) 				\
type								\
stat_##name ( const char *filename )				\
{								\
  struct stat buf ;						\
  int err = stat ( filename , &buf ) ;				\
  if ( err ) {							\
    fprintf ( stderr , "stat() failed: %s\n" , filename ) ;	\
    FAILURE ;							\
  }								\
  return buf.st_##name ;					\
}

GENERATE_STAT_FIELD ( time_t , mtime ) ;

#endif
