/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include "log.h"

/* simple logging facility.  gives us a nice central location
   control just how much we want to get spammed by KOTH */

Levels_log log_level = INTERESTING;

inline void logPrintf(Levels_log level, char *fmt, ...)
{
    if(log_level < level)
	return;
    else
    {
	va_list ap;
	char buf[4096];
	char hour[9];		/* eg. strlen("14:10:05") + 1 == 9 */
	time_t t;


	t = time(NULL);
	strftime(hour, 9, "%H:%M:%S", localtime(&t));
	va_start(ap, fmt);
	vsprintf(buf, fmt, ap);
	fprintf(stderr, "[%s] %s", hour, buf);
	va_end(ap);
    }
}
