/***************************************************************************
                          kwcentryspin.cpp  -  description
                             -------------------
    begin                : Mon Feb 3 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentryspin.h"

KWCEntrySpin::KWCEntrySpin(const QString & inscr, int row, int min, int max, int step,  QWidget *parent, const char *name ) : KWCEntry(inscr, row, parent,name)
{
	pollingSpin = new PollingSpinBox(min, max, step, this);
	pollingSpin->setGeometry(*rightWidgetRect);
	pollingSpin->resize(50, 20);
	pollingSpin->show();

  unitLabel = new QLabel(this);
  unitLabel->move(rightWidgetRect->left() + pollingSpin->width() + 10, rightWidgetRect->top());
  unitLabel->resize(50, 20);
  unitLabel->setText("sec");
  unitLabel->show();
	
  connect(pollingSpin, SIGNAL(valueChanged(int)), this, SLOT(valueChangedSlot(int)));
}

KWCEntrySpin::~KWCEntrySpin(){
}

/** No descriptions */
void KWCEntrySpin::valueChangedSlot(int value)
{
	valueChanged(value);	
}

/** No descriptions */
void KWCEntrySpin::setValue(int value)
{
  pollingSpin->setValue(value);
}
