// LabPlot : LabPlotPart.cc

#include <iostream>
#include <qlabel.h>
#include <kinstance.h>
#include <klocale.h>
#include <kaboutdata.h>

#include "LabPlotPart.h"

using namespace std;

extern "C" {
    void *init_libLabPlot() {
        return new LabPlotFactory;
    }
};

// We need one static instance of the factory for our C 'main' function
KInstance *LabPlotFactory::s_instance = 0L;

LabPlotFactory::LabPlotFactory() {}

LabPlotFactory::~LabPlotFactory() {
    if (s_instance) {
        delete s_instance->aboutData();
        delete s_instance;
    }

    s_instance = 0;
}

KParts::Part *LabPlotFactory::createPartObject(QWidget *parentWidget, const char *widgetName,
	QObject *parent, const char *name, const char *classname, const QStringList& args ) {
	KParts::Part *obj = new LabPlotPart(parentWidget, widgetName,parent,name);
	return obj;

}

KInstance *LabPlotFactory::instance() {
    if ( !s_instance )
        s_instance = new KInstance( aboutData() );
    return s_instance;
}

KAboutData *LabPlotFactory::aboutData() {
  KAboutData *about = new KAboutData("LabPlot Viewer", I18N_NOOP("LabPlot Viewer"), LVERSION);
  return about;
}

LabPlotPart::LabPlotPart(QWidget *parentW, const char *wname,QObject *parent, const char *name)
    : KParts::ReadOnlyPart(parentW, wname) {
    setInstance(LabPlotFactory::instance());

    p=parentW;
    setWidget(p);
    //p->adjustSize();

    	m_extension = new LabPlotBrowserExtension(this);
}

LabPlotPart::~LabPlotPart() { closeURL(); }

bool LabPlotPart::openFile() {
	MainWin *mw =  new MainWin("MainWindow",m_file);
	ws =  mw->getWorkspace();
	ws->resize(p->size());
	setWidget(ws);
	ws->reparent(p,QPoint(0,0),true);
    	//ws->adjustSize();
	
	// TODO : resize ws with parent !

	return true;
}

bool LabPlotPart::closeURL() { return true; }

LabPlotBrowserExtension::LabPlotBrowserExtension(LabPlotPart *parent)
    : KParts::BrowserExtension(parent, "LabPlotBrowserExtension")
{}

LabPlotBrowserExtension::~LabPlotBrowserExtension() {}

