//LabPlot: Legend.h

#ifndef LEGEND_H
#define LEGEND_H

#include <qfont.h>
#include <qpainter.h>
#include "GraphList.h"
#include "Symbol.h"

class Legend {
public:
	Legend();
	void save(QTextStream *t);
	void open(QTextStream *t, int version);
	void setFont(QFont font) { f = font; }
	QFont font() { return f; }
	void enable(bool b) { e = b; }
	bool enabled() { return e; }
	void setPosition(double X, double Y) { x = X; y = Y; }
	double X() { return x; }
	double Y() { return y; }
	void enableBorder(bool b) { border = b; }
	bool borderEnabled() { return border; }
	void draw(QPainter *p, PType type, GraphList *graphlist, Point pos, Point size,int w, int h);
	bool inside(int X, int Y);
private:
	double x,y;			// position 0..1
	int x1, y1, x2, y2;		// legend box
	QFont f;	
	bool border;			// border enabled
	bool e;				// legend enabled
	int namelength;		// legend width
};

#endif //LEGEND_H
