/***************************************************************************
                          hbcicryptkey.h  -  description
                             -------------------
    begin                : Sat Jun 30 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */


#ifndef HBCICRYPTKEY_H
#define HBCICRYPTKEY_H

#include <string>
#include <openhbci/dllimport.h>

using namespace std;

namespace HBCI {
/**
 * @short Abstract base class for Crypto-Keys
 * @author fabian kaiser
 */
class DLLIMPORT CryptKey {
public: 
	CryptKey();
	virtual ~CryptKey();
	
	/**
	 * set the data on which an operation should be performed
	 * (we create a copy of this data)
	 */
	void setData(const string &data) { intData = data;};
	
	/**
	 * return data that was transformed
	 */
	const string &getData() const { return intData;};
	
	/**
	 * encrypt data
	 */
	virtual bool encrypt() = 0;
	
	/**
	 * decrypt data
	 */
	virtual bool decrypt() = 0;

protected:
	string intData;
};
} /* namespace HBCI */
#endif
