NAME
     wnsplx -- simplex method package

SYNOPSIS
     #include "wnmat.h"


     wn_simplex_method(&code,&objective,&shadow_prices,&solution,
                       objective_vect,mat,right_side)
     int code;
     double objective;
     wn_vector shadow_prices,solution,objective_vect;
     wn_matrix mat;
     wn_vector right_side;


     wn_simplex_method_raw(&code,&objective,raw_shadow_prices,raw_solution,
                           raw_objective_vect,raw_mat,raw_right_side,
                           len_i,len_j)
     int code;
     double objective;
     double *raw_shadow_prices,*raw_solution,*raw_objective_vect;
     double **raw_mat;
     double *raw_right_side;
     int len_i,len_j;


     wn_raw_simplex_loop(&code,mat,right_side,non_zero_vars,zero_vars,
                         len_i,len_j)
     int code;
     double **mat;
     double *right_side;
     int *non_zero_vars,*zero_vars;
     int len_i,len_j;


DESCRIPTION
     This package solves the "linear programming" problem easily and
     efficiently.  The "linear programming" problem is the following
     optimization problem:

         CHOOSE solution[j] TO MAXIMIZE

             sum_over(j){ objective_vect[j]*solution[j] } 

         WHILE SATISFYING THE CONSTRAINTS

             for_all(i){ sum_over(j){mat[i][j]*solution[j]} == right_side[i] }

                 AND

             for_all(j){ solution[j] >= 0 }

     Difficult optimization problems from many fields can be put into
     this form, and thus solved efficiently with this package.

     "wn_simplex_method" solves the above problem for "wn_matrix"
     and "wn_vector" input; "wn_simplex_method_raw" works
     with raw arrays of double's.

     Set "objective_vect" to NULL if you want any feasible solution;
     set "shadow_prices" to NULL if you don't care about shadow prices.

     For an introduction to the linear programming problem, consult
     [1] and [2].  The basis of the algorithm used here is given in [3].
     However, the algorithm used here is randomized to avoid
     various degeneracy problems.  

     Naive users should confine themselves to "wn_simplex_method" and
     "wn_simplex_method_raw".  "wn_raw_simplex_loop" makes available
     to sophisticated users the (randomized) simplex loop given in [3]
     in raw form, useful for "crashing" specialized problems.

RESOURCES
     Solving the simplex problem using "wn_simplex_method" or 
     "wn_simplex_method_raw" requires

       WORST and AVERAGE CASE:

         time = len_i^2 * len_j
         stack memory = 1
         dynamic memory = len_i*len_j

     Randomizing achieves this outstanding worst case performance.

     "wn_raw_simplex_loop" requires

       WORST and AVERAGE CASE:

         time = len_i * len_j
         stack memory = 1
         dynamic memory = 0

     for each iteration.  No more than order len_i iterations are required
     for an optimal solution; crashing may yield better results.

DIAGNOSTICS
     code == WN_SUCCESS  for successful solution.
     code == WN_UNBOUNDED  for unbounded solution.
     code == WN_INFEASIBLE if no solution satisfies the constraints.

     WN_INFEASIBLE also given if "mat" is degenerate, even if solutions
     are feasible.
  
BUGS
     This code is new and has not been tested in large industrial
     applications.

SEE ALSO
     wnminv, wnanl

REFERENCES
     [1]  F. Hillier and G. Lieberman:  Introduction to Operations Research.
               Holden-Day Inc.

     [2]  J. Franklin:  Methods of Mathematical Economics.  
               Springer-Verlag.

     [3]  G. B. Dantzig, A. Orden, and P. Wolfe:  Generalized Simplex 
               Method for Minimizing a Linear Form under Linear 
               Inequality Restraints, Pacific J. Math. Vol. 5 (1955)
               pp. 183-195.

AUTHOR
     Will Naylor


