//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: globals.h,v 1.1.1.1 2003/10/29 10:05:15 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef GLOBALS_H
#define GLOBALS_H

#include <sys/types.h>
#include <qstring.h>
#include <qfont.h>
#include <qnamespace.h>
#include <qaction.h>
#include "value.h"
#include "mtc.h"

#include <unistd.h>

extern int recFileNumber;

extern bool alsaFound;
extern bool audioTimebase;

extern int division;
extern volatile int sampleRate;
extern volatile int segmentSize;
extern int rtcTicks;
extern int minMeter;
extern double minSlider;
extern int guiRefresh;

extern QString helpBrowser;

extern bool noAudio;
extern bool noJack;
extern bool noAlsa;
extern bool useJackAudio;
extern bool useAlsaAudio;

extern bool hIsB;

extern const signed char sharpTab[14][7];
extern const signed char flatTab[14][7];

extern QString museGlobalLib;
extern QString museGlobalShare;
extern QString museUser;
extern QString museProject;

extern bool debugMode;
extern bool midiInputTrace;
extern bool midiOutputTrace;
extern bool debugMsg;
extern bool debugSync;
extern bool loadPlugins;

extern bool realTimeScheduling;
extern int realTimePriority;
extern const char* midi_file_pattern[];
extern const char* med_file_pattern[];
extern const char* image_file_pattern[];
extern const char* ctrl_file_pattern[];

extern QString scoreBg;    // Background Pixmap Pathname for score canvas

extern double paperWidth;
extern double paperHeight;
extern double topMargin;
extern double bottomMargin;
extern double leftMargin;
extern double rightMargin;
extern double printScale;
extern int barsPage;
extern double beamWidth;
extern double beamSpacing;
extern double beamSlopeTrigger;

extern QFont font0;       // 12pt
extern QFont font1;       // 8pt
extern QFont font2;       // 10 pt
extern QFont font3;       // 10 pt bold
extern QFont font4;       // 8 pt bold
extern QFont font5;       // 12pt typewriter

extern Qt::ButtonState globalKeyState;

extern bool extendedMidi;
extern int midiDivision;      // division for midi export

extern int midiInputPorts;          // receive from all devices
extern int midiInputChannel;        // receive all channel
extern int midiRecordType;          // receive all events

#define MIDI_FILTER_NOTEON    1
#define MIDI_FILTER_POLYP     2
#define MIDI_FILTER_CTRL      4
#define MIDI_FILTER_PROGRAM   8
#define MIDI_FILTER_AT        16
#define MIDI_FILTER_PITCH     32
#define MIDI_FILTER_SYSEX     64

extern int midiThruType;            // transmit all events
extern int midiFilterCtrl1;
extern int midiFilterCtrl2;
extern int midiFilterCtrl3;
extern int midiFilterCtrl4;

#define CMD_RANGE_ALL   0
#define CMD_RANGE_SELECTED    1
#define CMD_RANGE_LOOP  2

extern QActionGroup* undoRedo;
extern QAction* undoAction;
extern QAction* redoAction;

extern QActionGroup* transportAction;
extern QAction* playAction;
extern QAction* startAction;
extern QAction* stopAction;
extern QAction* rewindAction;
extern QAction* forwardAction;
extern QAction* loopAction;
extern QAction* punchinAction;
extern QAction* punchoutAction;
extern QAction* recordAction;
extern QAction* panicAction;

class AudioMixerApp;
class MusE;
extern AudioMixerApp* audioMixer;
extern MusE* muse;

extern int preMeasures;
extern unsigned char measureClickNote;
extern unsigned char measureClickVelo;
extern unsigned char beatClickNote;
extern unsigned char beatClickVelo;
extern unsigned char clickChan;
extern unsigned char clickPort;
extern bool precountEnableFlag;
extern bool precountFromMastertrackFlag;
extern int precountSigZ;
extern int precountSigN;
extern bool precountPrerecord;
extern bool precountPreroll;
extern bool midiClickFlag;
extern bool audioClickFlag;

extern bool rcEnable;
extern unsigned char rcStopNote;
extern unsigned char rcRecordNote;
extern unsigned char rcGotoLeftMarkNote;
extern unsigned char rcPlayNote;


extern uid_t euid, ruid;
extern void doSetuid();
extern void undoSetuid();
#endif
