//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: symbols.h,v 1.1.1.1 2003/10/29 10:05:26 wschweer Exp $
//  (C) Copyright 1999,2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SYMBOLS_H__
#define __SYMBOLS_H__

#include <qbitmap.h>
#include <qpainter.h>

//---------------------------------------------------------
//   Sprite
//---------------------------------------------------------

class Sprite : public QBitmap {
      QPoint hotSpot;
   public:
      Sprite(int w, int h, const unsigned char* bits, const QPoint& hs)
         : QBitmap(w, h, bits, true)
            {
            hotSpot = hs;
            setMask(*this);
            }
      void draw(QPainter& p, const QPoint& pt) {
            p.drawPixmap(pt - hotSpot, *this);
            }
      };


const int NUM_KEYS = 14;

extern QBitmap* keyBM[14];
extern QBitmap* note0BM;
extern QBitmap* note1BM;
extern QBitmap* note2BM;
extern void initSymbols();

extern Sprite* sharpSprite;
extern Sprite* sharp2Sprite;
extern Sprite* natSprite;
extern Sprite* flatSprite;
extern Sprite* flat2Sprite;


extern QBitmap* flagBM;
extern QBitmap* flagIBM;
extern QBitmap* dotBM;
extern QBitmap* restBM[6];

extern QPixmap* noteBM[7];
extern QPixmap* snoteBM[9];
extern QPixmap* enhBM[5];
extern QPixmap* notenposBM;
extern QPixmap* configBM;
extern QPixmap* notedotBM;
extern QPixmap* note3BM;
extern QPixmap* dynBM[12];

extern QPixmap* ts44;  // 4/4 time signature
extern QPixmap* ts22;  // 3/4 time signature
extern QPixmap* bracketBM;
extern QPixmap* flipNote;
extern QPixmap* upVoice;
extern QPixmap* downVoice;

#endif

