#TRUSTED adac2d1f439bf32e4e1ba189d2664ec33960df01ea57480cefe37a610bae74fef1e22d4110119420f9c5ccbb7e439f87ab79d2c5e34c42c9bb7ece9dd569bcad334d178fe2a7edb26267e40a736e67c6ce100d9461bb6d0febebd33f07f2ad32163b5efbcc1a8a83f80699662941f8c21140ab126d695f903041e22462e4d13a5ad8b46088b96fa78cc9461015795c25387eb7ccc9c7a16d494ba100348a016960a9011176ad624f3680c9fcb9c29332a9db5d218ee91fdc8950db94bd3f102e8044930bb7e2acea7fbfdd287cccbeeb686c453e87e32da82a7a283bc5c7e3f14c2d51ccf240aa84cc50639fecab96917fab107a561d494b005276a80cd5f746077946a2b203b5ee2d6af42ac1853a4474a739d8914073a6956bfdacd3b9a68a4947eafe0005f0c9a589d742860c7c2f949ebbf5579947a24a030257f067e1ed78a8c070df04afc326004a8d0283232a6dbbdb56fef3cf23d916c1f8badd95769c6ec894ea15a394011117bc221b83a37b581db42be7781377099319b6ed84210315777a369b0f21878523b535465c0803a4cb7bb01335f3f15e0dd4f07e855ebb272057999e949131791b630acc01fe23bed870eb4d790e190674bbc03a6cf1333fcf0284fe4cf63907131b175ff4bcb211f6d33c3a96f00980699041a2cecf9fe3ad01f2f3835453024954589fd280d0d0e357ce81e60496069b65763a08bb
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15885);
 script_version ("1.1");
 name["english"] = "Hydra: SMTP AUTH";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SMTP AUTH accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SMTP AUTH authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/smtp", 25);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "find_service_3digits.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/smtp");
if (! port) port = 25;
if (! get_port_state(port)) exit(0);
# NB: Hydra will exit if SMTP AUTH is not enabled

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "smtp-auth";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/smtp-auth/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SMTP accounts:\n' + report);
