/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;

public class ConstantConstraint
extends Constraint {
    Environment environment;
    static ConstantConstraint instance;

    public static ConstantConstraint getInstance(Environment environment) {
        ConstantConstraint result;
        if (environment != null) {
            result = environment.constantConstraint;
            if (result == null) {
                environment.constantConstraint = result = new ConstantConstraint(environment);
            }
        } else {
            result = instance;
            if (result == null) {
                instance = result = new ConstantConstraint(null);
            }
        }
        return result;
    }

    public static ConstantConstraint getInstance(Binding binding) {
        Constraint constraint = binding.constraint;
        if (constraint instanceof ConstantConstraint) {
            return (ConstantConstraint)binding.constraint;
        }
        return ConstantConstraint.getInstance(constraint.getEnvironment(binding));
    }

    public ConstantConstraint(Environment environment) {
        this.environment = environment;
    }

    public boolean isBound(Binding binding) {
        return true;
    }

    public Object get(Binding binding, Object defaultValue) {
        return binding.value;
    }

    public void set(Binding binding, Object value) {
        if (binding.value == value) {
            return;
        }
        throw new IllegalStateException("attempt to modify read-only variable: " + binding.getName());
    }

    public Environment getEnvironment(Binding binding) {
        return this.environment;
    }
}

