/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_UI_INTERFACE_CALLBACKS_H__
#define __NB_UI_INTERFACE_CALLBACKS_H__

#include <gtk/gtk.h>

void		nb_ui_cb_on_new_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_save_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_attach_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_delete_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_import_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_export_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_about_clicked (GtkWidget * widget, gpointer user_data);
gboolean	nb_ui_cb_on_quit_clicked (GtkWidget * widget, gpointer user_data);

void		nb_ui_cb_on_option_menu_type_note_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_option_menu_type_personal_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_option_menu_type_problem_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_option_menu_type_tipntrick_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_option_menu_type_bookmark_clicked (GtkWidget * widget, gpointer user_data);

void		nb_ui_cb_on_option_menu_status_none_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_option_menu_status_open_clicked (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_option_menu_status_solved_clicked (GtkWidget * widget, gpointer user_data);

void		nb_ui_cb_on_show_hide_attachment_clicked (GtkWidget * widget, gpointer user_data);

void		nb_ui_cb_on_note_edited (GtkWidget * widget, gpointer user_data);

void		nb_ui_cb_on_search_edited (GtkWidget * widget, gpointer user_data);
void		nb_ui_cb_on_clear_search_clicked (GtkWidget * widget, gpointer user_data);

void		nb_ui_cb_on_export_validate (GtkWidget * widget, gpointer user_data);

#endif
