/* +------------------------------------------------------------------------+
   |                                                                        |
   |                      Entiers de longueur arbitraire                    |
   |                                                                        |
   |                              Comparaisons                              |
   |                                                                        |
   +------------------------------------------------------------------------+ */

/* M. Quercia, 31/01/2001 */

#include "long_int.h"
#include "long_int-s.h"


  /* +----------------------------------------------------------+
     |  compare a et b, retourne la longueur algbrique de a-b  |
     +----------------------------------------------------------+ */

#ifndef have_sn_cmp
longueur xn(cmp)(naturel a, longueur la, naturel b, longueur lb) {
  longueur l;

  /* limine les zros de tte */
  while ((la) && (a[la-1] == 0)) la--;
  while ((lb) && (b[lb-1] == 0)) lb--;

  /* si les longeurs sont gales, compare les chiffres */
  if (la==lb) {
    for (l=la-1; (l>=0) && (a[l] == b[l]); l--);
    l++;
    if ((l) && (a[l-1] < b[l-1])) l = -l;
  }
  else {l = (la > lb) ? la : -lb;}

  return(l);
}
#endif

                      /* +------------------+
                         |  Compare a et b  |
                         +------------------+ */

#ifndef have_sz_cmp
long xz(cmp)(entier *a, entier *b) {
  longueur la = Lg(a), lb = Lg(b);
  longueur sa = Signe(a), sab = sa ^ Signe(b);
  zdouble s;
 
  if (sab) return((sa) ?  -1 : 1);
  s = xn(cmp)(a->val,la,b->val,lb);
  return ((s < 0) ? ((sa) ? 1 : -1) :
	  (s > 0) ? ((sa) ? -1 : 1) : 0);
}
#endif
