/*
 * replicator.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "tclcl.h"
#include "module.h"
#include "pktbuf.h"

/*
 * Have this since next pointer in module might be overloaded
 * in multiple replicators.
 */
struct rep_target {
	struct rep_target* next;
	Module* m;
};

class PacketReplicator : public PacketModule {
public:
	virtual int command(int argc, const char*const* argv);
protected:
	PacketReplicator() : targets_(0) {}
	~PacketReplicator();
	rep_target* targets_;
};

class NoCopyPacketReplicator : public PacketReplicator {
public:
	virtual void recv(pktbuf* pb);
};

class CopyPacketReplicator : public PacketReplicator {
public:
	virtual void recv(pktbuf* pb);
};

static class CopyPacketReplicatorClass : public TclClass {
public:
	CopyPacketReplicatorClass() : TclClass("Replicator/Packet/Copy") {}
	TclObject* create(int, const char*const*) {
		return (new CopyPacketReplicator);
	}
} copy_pktrep_class;

static class NoCopyPacketReplicatorClass : public TclClass {
public:
	NoCopyPacketReplicatorClass() : TclClass("Replicator/Packet/NoCopy") {}
	TclObject* create(int, const char*const*) {
		return (new NoCopyPacketReplicator);
	}
} nocopy_pktrep_class;

PacketReplicator::~PacketReplicator()
{
	rep_target* t;
	rep_target* next;
	for (t = targets_; t != 0; t = next) {
		next = t->next;
		delete t;
	}
}

int PacketReplicator::command(int argc, const char*const* argv)
{
	if (argc == 3) {
		if (strcmp(argv[1], "add-target") == 0) {
			Module* m = (Module*)TclObject::lookup(argv[2]);
			rep_target* t = new rep_target;
			t->m = m;
			t->next = targets_;
			targets_ = t;
			return (TCL_OK);
		}
		if (strcmp(argv[1], "remove-target") == 0) {
			Module* m = (Module*)TclObject::lookup(argv[2]);
			rep_target** t;
			for (t = &targets_; *t != 0; t = &(*t)->next) {
				if ((*t)->m == m) {
					rep_target* tmp = *t;
					*t = (*t)->next;
					delete tmp;
					break;
				}
			}
			return (TCL_OK);
		}
	}
	return (PacketModule::command(argc, argv));
}

void NoCopyPacketReplicator::recv(pktbuf* pb)
{
	if (targets_ == 0) {
		pb->release();
		return;
	}
	/* FIXME Need ref counts to make this work. */
	for (rep_target* t = targets_; t != 0; t = t->next) {
		PacketModule* p = (PacketModule*)t->m;
		p->recv(pb);
	}
}

void CopyPacketReplicator::recv(pktbuf* pb)
{
	if (targets_ == 0) {
		pb->release();
		return;
	}
	rep_target* t;
	PacketModule* p;
	for (t = targets_; t->next != 0; t = t->next) {
		pktbuf* newpb = (pktbuf*)pb->copy();
		p = (PacketModule*)t->m;
		p->recv(newpb);
	}
	p = (PacketModule*)t->m;
	p->recv(pb);
}
