# ui-mbv2.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/collaborator/ui-mbv2.tcl,v 1.5 2002/02/03 04:21:46 lim Exp $


#
UISource/Mbv2 public build_widget { path } {
	$self instvar observer_
	$path configure -command "tk_popup $path.menu \[winfo pointerx $path\]\
			\[winfo pointery $path\]"

	menu $path.menu
	$path.menu add radiobutton -label "Track this source" \
			-variable [$observer_ tkvarname track_] \
			-value [[$self src] source_id]
	$path.menu add radiobutton -label "Track any active source" \
			-variable [$observer_ tkvarname track_] -value any
	$path.menu add radiobutton -label "Don't track any source" \
			-variable [$observer_ tkvarname track_] -value {}
}


#
Observer/Mbv2 public init { sm mbv2ui } {
	$self next
	$self set sm_ $sm
	$self set ui_ $mbv2ui

	$self tkvar track_
	trace variable track_ w "$self modify_track"
	set track_ any
}

Observer/Mbv2 public session { s } {
	$self set mbv2_session_ $s
	$s attach_observer $self
}


Observer/Mbv2 public modify_track { args } {
	$self tkvar track_
	$self instvar ui_
	[$ui_ canvmgr] source_to_follow $track_
}


#
Observer/Mbv2 private create_multi_source { src name cname } {
	$self instvar sm_ msrcs_ srcid2src_
	set srcid2src_([$src source_id]) $src
	set msrcs_($src) [$sm_ register mbv2 $src $cname $self]
	set uisrc [$msrcs_($src) get_uisource mbv2 $src]
	$msrcs_($src) change_name $uisrc $name
}


#
# Register a src in the src display.  This happens for all the
# srcs participating in the conferencing (e.g., including
# those not actually sending data).
#
Observer/Mbv2 public source_update { src name cname } {
	$self instvar srcnames_ msrcs_

	if { $name=={} } {
		if { $cname=={} } { set name unknown } else { set name $cname }
	}

	$self instvar msrcs_
	if ![info exists msrcs_($src)] {
		$self create_multi_source $src $name $cname
	} elseif { [$msrcs_($src) name] != $name } {
		set uisrc [$msrcs_($src) get_uisource mbv2 $src]
		$msrcs_($src) change_name $uisrc $name
	}
}


#
# Remove a src from the src display.  This happens when
# a party quits or has been dead for a sufficiently long time.
# We assume the src has already been deactivated.
#
Observer/Mbv2 public unregister { src } {
}


Observer/Mbv2 public activity { srcid pageid cmdid canvid islocal } {
	$self instvar activity_ msrcs_ srcid2src_ id_

	if ![info exists srcid2src_($srcid)] return
	set src $srcid2src_($srcid)

	if [info exists id_($src)] {
		after cancel $id_($src)
	} else {
		set uisrc [$msrcs_($src) get_uisource mbv2 $src]
		$uisrc highlight 1
	}

	set id_($src) [after 500 "$self unhilit $src"]
}


Observer/Mbv2 public unhilit {src} {
	$self instvar msrcs_ id_
	if [info exists msrcs_($src)] {
		set uisrc [$msrcs_($src) get_uisource mbv2 $src]
		$uisrc highlight 0
	}
	unset id_($src)
}
