# application-hmsp.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/hmsp/application-hmsp.tcl,v 1.10 2002/02/03 04:27:11 lim Exp $


import Application Timer/Periodic RTSP_Client

# Headless version of MSP. It's a bit easier to test the rtsp client/server by tweaking scripts compared to bringing up a GUI.  This is just a rough start...

Class HMSP_Application -superclass {Application Timer/Periodic}

HMSP_Application instproc init { argv } {

	$self instvar ui_ net_ session_ delta_ history_ offset_

	set o [$self options]
	$self next msp
	$self init_args $o
	$self init_resources $o
	$o parse_args $argv
	$self parse_file

	set offset_ 0
	set history_ ""
	set   net_ [new RTSP_Client]
	$net_ init_vars $self
	if {[$self get_option autoStart] == "true"} {
		set url [$self get_option defaultAddr]
		$self open $url
	}
}

# Address file is downloaded using HTTP and parsed here.
HMSP_Application private parse_file { } {
	$self instvar name_ spurts_ acolor_ uname_

	set sFile [$self get_option serverFile]
	if {$sFile == ""} {
		return 0
	}
	set fd [open $sFile "r"]
	if { $fd <  0 } {
		puts "$name_: error opening $sFile"
		exit 1
	}

	while { [gets $fd line] > 0 } {
		set cmd [lindex $line 0]
		switch $cmd {
			uri {
				set v [lindex $line 1]
				$self add_default defaultAddr $v
				$self add_default autoStart "true"
			}
			activity {
				# Set up bindings so that look-ups can occur both ways.
				set info [split [join [lrange $line 1 end]] ":"]
				set name [string trim [lindex $info 0]]
				set color [string trim [lindex $info 2]]
				set spurts_($name) [string trim [lindex $info 1]]
				set acolor_($name) $color
				set uname_($color)  $name
			}
		}
	}
	close $fd
	return 1
}

HMSP_Application instproc init_args o {
	$o register_option -server serverFile
}

# Invoked when slider is dragged.
HMSP_Application instproc play-offset { } {
	$self instvar net_ slider_

        if {$slider_ == "ACTIVE"} {
		$net_ send "PLAY"
		$self stop
		$self start_timer
	}
	return
}

HMSP_Application instproc display-stats { } {
}

HMSP_Application instproc start_vic args {
	puts "vic $args"
}
HMSP_Application instproc start_vat args {
	puts "vat $args"
}

HMSP_Application private open { url {off 0} } {
	$self instvar net_ history_ ui_
	$self clean_up
	$net_ open $url
	$net_ wait READY
	return
}

HMSP_Application instproc offset { } {
	$self instvar offset_
	return $offset_
}

HMSP_Application public play_pause { } {
	$self instvar net_ slider_
	if {$slider_ == "ACTIVE"} {
		$net_ playOrPause
	}
}

HMSP_Application public play { } {
	$self instvar net_
	$net_ play
}

HMSP_Application public play-update args {
	puts stderr "get rid of play-update"
}


HMSP_Application public play_stop { } {
	$self tkvar offset_
	$self instvar net_ slider_
	if {$slider_ == "ACTIVE"} {
		set offset_ 0
		$net_ playOrPause STOP
	}
}

#
# 'spurts' is a list of start times, expressed in % of total length
#
HMSP_Application instproc update-activity { } {

	# acolor_ is the active color
	puts "++++ UPDATE"
	$self instvar ui_ spurts_ acolor_ uname_ seekto_ net_

	foreach user_name [array names spurts_] {
		set spurts $spurts_($user_name)
		set color  $acolor_($user_name)

#		set g [lindex [split [wm geometry .] "+"] 0]
#		set w [lindex [split $g "x"] 0]
		set w 650
		set e [$net_ set session_(endtime_)]
		set s [$net_ set session_(starttime_)]

		foreach starttime $spurts {
			set st [expr ($w - 40) * ($starttime - $s)/($e - $s) + 20]
#			set iid [$ui_(main).scale.activity create rect $st 10 [expr $st+2] 20 \
#					-fill $color -outline $color -tag $color]
#			$ui_(main).scale.activity bind $iid <ButtonPress-1> \
#				"$self tkvar offset_;set offset_ [expr $starttime - $s]; $self play-offset"
		}
	}
#	foreach color [array names uname_] {
#		set n $uname_($color)
#		$ui_(main).scale.activity bind $color <Enter> "$self show-balloon  %x %y {$n} $color"
#		$ui_(main).scale.activity bind $color <Leave> "$self hide-balloon"
#	}
}

#FIXME who made these?
HMSP_Application private clean_up { } {
#	$self clean-net
}

HMSP_Application instproc exit { } {
	$self instvar net_

	$self clean_up
	if {[info exists net_]} {
		$net_ send "CLOSE"
	}
	exit 0
}

HMSP_Application instproc play_update { label } {
	$self instvar ui_
	set label [string tolower $label]
	if {$label == "pause"} {
		$ui_(main).cp.playOrPause configure -text $label -image VcrIcons(pause)
		$self start_timer
	} else {
		$ui_(main).cp.playOrPause configure -text $label -image VcrIcons(splay)
		$self stop
	}
}

HMSP_Application instproc start_timer { } {
	$self instvar net_ delta_

	# Convert to msec
	set delta_ [expr [$net_ duration] * 0.001 * 1000]
	$self start $delta_
}

HMSP_Application instproc timeout { } {
	$self tkvar offset_
	$self instvar delta_

	set offset_ [expr $offset_ + $delta_ * 0.001]
#	$self update-elapsed
}

#
# this is more or less what mui has to do...!
#
HMSP_Application private init_resources o {
	$o add_default defaultmediaList "audio video"
	$o add_default videoAddr 224.8.8.2
	$o add_default videoPort 8000
	$o add_default videoTTL  16

	$o add_default audioAddr 224.8.9.2
	$o add_default audioPort 9000
	$o add_default audioTTL  16
#	$o add_default serverAddr "rtsp://mirage.cs.berkeley.edu:2025/archive/CSCW4/CSCW4"
#	$o add_default serverAddr "rtsp://rose.cs.berkeley.edu:12123/archive/CSCW4/CSCW4"
	$o add_default serverAddr "rtsp://heart.cs.berkeley.edu:2025/x/CSCW4/CSCW4"
	$o add_default mtu 1024
	$o add_default network ip
	$o add_default framerate 8
	$o add_default defaultTTL 16
	$o add_default maxbw -1
	$o add_default bandwidth 1000000
	$o add_default iconPrefix "AMASH Remote Player: "
	$o add_default priority 10
	$o add_default confBusChannel 0

	$o add_default videoFormat h.261
	$o add_default sessionType rtpv2
	$o add_default grabber none
	$o add_default stampInterval 1000
	$o add_default switchInterval 5
	$o add_default dither Dither
	$o add_default tile 1
	$o add_default filterGain 0.25
	$o add_default statsFilter 0.0625
	$o add_default useHardwareDecode false
	$o add_default infoHighlightColor LightYellow2
	$o add_default useJPEGforH261 false
	$o add_default stillGrabber false
	$o add_default siteDropTime "300"

	#
	# color resources
	#
	$o add_default medianCutColors 150
	$o add_default gamma 0.7

	#FIXME
	$o add_default jvColors 32

	$o add_default foundry adobe

	$o add_default suppressUserName true

	$o add_default softJPEGthresh -1
	$o add_default softJPEGcthresh 6

	$o add_default sunvideoDevice 0
	$o add_default enableBVC false
	$o add_default audioFormat PCM2

	# true to allow voice-switch to switch to self
	$o add_default vain false

	# list of sdes items to display in info window
	$o add_default sdesList "cname tool email note"

	# resources used by audio widgets FIXME merge
	$o add_default disabledColor gray50
	$o add_default highlightColor gray95
	$o add_default idleDropTime "20"
	$o add_default defaultPriority "100"

	# MeGa Resources
	$o add_default megaCtrl 224.4.5.24/50000/1
	$o add_default megaFormat h261
	# multicast is default
	$o add_default megaRecvPort 0

	# (scuba) default session bandwidth (kb/s).
	$o add_default maxSessionBW 128000
	# 60 seconds max startup wait for first message
	$o add_default megaStartupWait 60


### Vat startup defaults

	# colors
	$o add_default titleReleased "gray95"
	$o add_default titleHave "#aaaaaa"
	$o add_default titlePinned "black"

	$o add_default mikeGain "32"
	$o add_default lineinGain "180"
	$o add_default linein2Gain "180"
	$o add_default linein3Gain "180"
	$o add_default speakerGain "180"
	$o add_default jackGain "180"
	$o add_default lineoutGain "180"
	$o add_default lineout2Gain "180"

	$o add_default speakerMute "false"
	$o add_default mikeMute "true"

	$o add_default speakerMode "NetMutesMike"
	$o add_default jackMode "FullDuplex"
	$o add_default lineoutMode "NetMutesMike"
	$o add_default lineout2Mode "NetMutesMike"
	$o add_default maxPlayout "6"
	$o add_default lectureMode "false"
	$o add_default useNames "false"
	$o add_default defaultTTL "16"

	$o add_default filterLength "256"
	$o add_default filterMaxTaps "35"

	$o add_default meterEnable "true"
	$o add_default meterStyle "discrete"
	$o add_default inputPort "Mike"
	$o add_default outputPort "Speaker"
	$o add_default mikeAGC "false"
	$o add_default mikeAGCLevel "0"
	$o add_default speakerAGC "false"
	$o add_default speakerAGCLevel "0"

	$o add_default defaultPriority "100"
	$o add_default idleDropTime "20"
	$o add_default autoRaise "true"
	$o add_default externalEchoCancel "false"
	$o add_default silenceThresh "20"
	$o add_default talkThresh "0"
	$o add_default echoThresh "70"
	$o add_default echoSuppressTime "400"
	$o add_default keepSites "false"
	$o add_default muteNewSites "false"
	$o add_default sortSites "true"
	$o add_default compactSites "true"
	$o add_default compressionSlope "0.0625"
	$o add_default key ""
	$o add_default afDevice "-1"
	$o add_default afBlocks "2"
	$o add_default afSoftOuputGain "0"
	$o add_default afSoftInputGain "0"
	$o add_default siteDropTime "300"
	$o add_default audioFileName "/dev/audio"
	$o add_default statTimeConst 0.1
	$o add_default statsFilter 0.0625

	$o add_default mtu 1024
	$o add_default network ip
	$o add_default maxbw -1
	$o add_default bandwidth 128
	$o add_default confBusChannel 0
	$o add_default sessionType rtp

	$o add_default foundry adobe
	$o add_default recvOnly false

	$o add_default suppressUserName true

	# list of sdes items to display in info window
	$o add_default sdesList "cname tool email"
}
