# tdemo.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc ParseArgs {} {
    global argv;

    for {set i 0} {$i < [llength $argv]} {incr i} {
	if {[string compare [lindex $argv $i] "-subprogram"] == 0} {
	    incr i;
	    global subprogram;
	    set subprogram [lindex $argv $i];
	}
	if {[string compare [lindex $argv $i] "-num_nodes"] == 0} {
	    incr i;
	    global num_nodes;
	    set num_nodes [lindex $argv $i];
	}
    }
}

proc HandleRequest {sfd addr port} {
    global client_sock_fd;

    set client_sock_fd $sfd;
}

proc StartProc {my_addr my_port cmd args} {
    global client_sock_fd;
    global mash_bin tdemo_client

    set client_sock_fd "";

    puts "Starting $cmd $args";
    flush stdout;

    eval exec glurun $mash_bin $tdemo_client $my_addr $my_port $cmd $args >& /dev/null &;

    while {$client_sock_fd == ""} {
	update;
    }

    set client_host [gets $client_sock_fd];

    puts "Client started on $client_host";

    global env node_spec;

    set node_spec "${node_spec}-${client_host}";
    set env(GLUNIX_NODES) $node_spec;

    global sock_list;

    lappend sock_list $client_sock_fd;
    set client_sock_fd "";
}


set port 30111;
set cntrl_spec 224.3.2.1/22334/16
set subprogram TitleSubprogram

set node_spec production
set num_nodes 2

set mash_dir $env(HOME)/mash-code/mash
set mash_bin $mash_dir/bin/mash;
set tselect $mash_dir/tcl/psvp/test2/fx_tselect.tcl
set tinter $mash_dir/tcl/psvp/test2/fx_tinter.tcl
set tproc $mash_dir/tcl/psvp/test2/fx_proc.tcl
set tdemo_client $mash_dir/tcl/psvp/demos/glurun-client.tcl
set ui $mash_dir/tcl/psvp/test2/fx_ui.tcl

set env(TCLCL_IMPORT)
$env(HOME)/mash-code/mash:$env(HOME)/mash-code/mash/psvp/tcl:$env(HOME)/mash-code/mash/psvp/effects

cd $mash_dir;

ParseArgs;

set hname [exec hostname];

set habbr [lindex [split [string trim $hname] .] 0];

set env(GLUNIX_NODES) "${node_spec}-${habbr}";

set server_fd [socket -server HandleRequest $port];

StartProc $hname $port $ui -cntrl_spec $cntrl_spec

StartProc $hname $port $tselect -cntrl_spec $cntrl_spec;

StartProc $hname $port $tinter -cntrl_spec $cntrl_spec;

for {set i 0} {$i < $num_nodes} {incr i} {
    StartProc $hname $port $tproc -reg_comm_spec $cntrl_spec -subprogram $subprogram
}

