/*
 * ex.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/example/ex.cc,v 1.19 2002/02/03 03:04:55 lim Exp $
 */


#include "ex.h"
#include <unistd.h>
#include <string.h>
#include <tcl.h>
#include <sys/stat.h>

/* Mapping from CID to string names. */
//char *mappings_[MAX_NODES];

void 
srm_send1(srm_source_t source, unsigned int cid, unsigned char *data, int len)
{
	printf("(%p): opening send buffer for cid %d (%d bytes)\n",
	       source, cid, len);
	srm_send(source, cid, data, len, NULL);
}

unsigned int 
srm_calloc1(srm_source_t source, unsigned int parent, 
	    const unsigned char *container_name, int name_len)
{
	unsigned int cid;
	cid = srm_calloc(source, parent, container_name, name_len);
	printf("(%p): srm_calloc created cid %d (parent %d) for %s\n",
	       source, cid, parent, container_name);
	return cid;
}


/* 
 * Application-specific functions, may also serve as 
 * reasonable defaults for other application developers. 
 */
void 
srm_recv(srm_source_t source, unsigned int cid, unsigned int /* seqno */,
	 const unsigned char *data, int len, const srm_adu_info * /*info*/)
{
	/* Test recv_data function. */
	char filename[1024], *p;
	const unsigned char *cname;
	int l;
	strcpy(filename, "/tmp/");
	p = filename + strlen(filename);
	while (cid != SRMv2_ROOT_CID) {
		srm_get_container_name(source, cid, &cname, NULL);

		char **cnames;
		int cc;
		Tcl_SplitPath(cname, &cc, &cnames);
		char *comp = cnames[cc-1];

		if (*p) {
			l = strlen(comp);
			memmove(p+l+1, p, strlen(p)+1);
			memmove(p, comp, l);
			*(p+l) = '-';
		} else {
			strcpy(p, comp);
		}
		Tcl_Free((char *)cnames);
		cid = srm_get_parent_cid(source, cid);
	}
	write_file(filename, data, len);
}

int 
srm_should_recover(srm_source_t /*source*/, unsigned int /*cid*/,
	    unsigned int /*ss*/, unsigned int /*es*/)
{
	return 1;
}

void
srm_read_adu(srm_source_t source, unsigned int cid, unsigned int /* seqno */,
	     unsigned char **data_ptr, unsigned int *len_ptr,
	     srm_free_proc *free_proc_ptr, srm_adu_info * /*info*/)
{
	/* Must first perform cid <--> name translation. */
	const unsigned char *filename;
	srm_get_container_name(source, cid, &filename, NULL);
#ifndef NDEBUG
	printf("filename = %s\n", filename);
#endif

	struct stat buf;
	stat((char *)filename, &buf);
	if (S_ISDIR(buf.st_mode)) {
		static char comment[200];
		sprintf(comment, "This is an internal ADU for %s\n", filename);
		*data_ptr = (unsigned char *) comment;
		*len_ptr = strlen(comment);
		*free_proc_ptr = NULL;
	} else {
		read_file((char*)filename, data_ptr, len_ptr, free_proc_ptr);
	}
}


void
srm_source_update(srm_source_t /* source */, const unsigned char *info,
		  int /* len */)
{
	printf("source update received \n");
	if (info) {
		printf("\t %s\n", info);
	}
}


#if 0
void srm_construct_cid_mapping(srm_source_t source,
			       unsigned int cid, 
			       char **data_ptr, int *len_ptr,
			       srm_free_proc *free_proc_ptr)
{
	*data_ptr = mappings_[cid];
	if (*data_ptr) *len_ptr = strlen(*data_ptr) + 1;
	*free_proc_ptr = NULL;
#ifndef NDEBUG
	printf("inside construct_mapping: %p (%p), %d (%p)\n", *data_ptr,
	       data_ptr, *len_ptr, len_ptr);
#endif
}


void srm_recv_cid_mapping(srm_source_t source,
					  unsigned int cid,
					  const char *data, int len)
{
	insert_mapping(data, cid);
}
#endif


/* 
 * Control flow occurs as illustrated below. 
 *
 *  srm-main.cc: main()
 *               ex.cc: SRMv2_AppInit (app-specific initialization.
 *                                     setting up timer handlers, 
 *                                     network handlers.)
 *
 *  srm-main.cc: do_eventloop()
 *               Application-specific handlers in response to 
 *               events. 
 */

void
SRMv2_AppInit(int argc, char **argv) 
{
	if (argc < 4) {
		printf("Usage: %s addr port ttl [src_directory]\n", argv[0]);
		exit(1);
	}
	char* dirname = 0;
	unsigned int addr = (unsigned) LookupHostAddr(argv[1]);
	unsigned int port = (unsigned) atoi(argv[2]);
	unsigned int ttl  = (unsigned) atoi(argv[3]);
	if (argc == 5) /* Sender specifies relative filename. */
		dirname = argv[4];

	srm_session_t session = srm_create_session(addr, port, port, ttl);

	/* Simulate losses. For experimental purposes only. */
	srm_set_drop_probability(session, 0.2);
	srm_source_t s1 = srm_create_source(session, NULL);
	srm_source_t s2 = srm_create_source(session, NULL);
	srm_callbacks c = {
		srm_recv,
		srm_should_recover,
		srm_read_adu,
		srm_source_update
	};
	srm_set_callbacks(session, &c);

	if (dirname > 0) {
		sched_files(s1, dirname, 0);
		sched_files(s2, dirname, 1);
	}
	return;
}


void 
sched_files_per_dir(srm_source_t source, char *dirname,
		    unsigned int parent_cid)
{
	char *filename; 
	glob_t *pglob = new glob_t;
	char *pattern = new char [strlen(dirname) + strlen("*.tcl") + 3];
	strcpy(pattern, dirname);
	strcat(pattern, "/*");
	glob(pattern, GLOB_NOSORT, 0, pglob);

#if defined(__linux__)
	int nfiles = pglob->gl_pathc;
#else
	int nfiles = pglob->gl_matchc;
#endif
	unsigned int cid = parent_cid; 

	/* Create containers for the tail component in pathname */
	if (dirname) {
		cid = srm_calloc1(source, cid, (unsigned char *)dirname,
				 strlen(dirname)+1);

		char comment[200];
		sprintf(comment, "This is an internal ADU for %s\n", dirname);
		srm_send1(source, cid, (unsigned char*)comment,
			 strlen(comment));
	}

	unsigned int base = cid;
	for (int i = 0; i < nfiles; i++) {
		filename = pglob->gl_pathv[i];
		/* 
		 * Create a hierarchy of containers.
		 */
		cid = base;
		if (!filename) continue;

		/*
		 * check if this is a directory
		 */
		struct stat buf;
		stat(filename, &buf);
		if (S_ISDIR(buf.st_mode)) {
			sched_files_per_dir(source, filename, cid);
			continue;
		}
		
		/* 
		 * Meta data could be any app-specific string. 
		 * E.g., the path name of the file. 
		 */
		cid = srm_calloc1(source, cid, (unsigned char *)filename,
				 strlen(filename)+1);
		unsigned char *data=NULL;
		
		int len=0;
		srm_free_proc free_proc=NULL;
		read_file(filename, &data, &len, &free_proc);
#ifndef NDEBUG
		printf("Len <%d.%d> = %d\n", cid, 0, len);
#endif
		if (len > 0) {
			srm_send1(source, cid, (unsigned char*)data, len);
		}
		if (data && free_proc) (*free_proc)(data);
	}
	globfree(pglob);
	delete pattern;
}


void 
sched_files(srm_source_t source, char *dirname, int flag)
{
	int cid;
	if (flag) {
		cid = srm_calloc1(source, SRMv2_ROOT_CID, "foobar", 7);
	} else {
		cid = SRMv2_ROOT_CID;
	}
	sched_files_per_dir(source, dirname, cid);
}


void
read_file(const char* filename, unsigned char **dataptr, unsigned int *lenptr,
	  srm_free_proc *free_ptr)
{
	int fd = open(filename, O_RDONLY);
	if (fd > 0) {
		*lenptr  = lseek(fd, 0, SEEK_END);
		*dataptr = (unsigned char*)malloc(*lenptr);
		lseek(fd, 0, SEEK_SET);
		read(fd, (void *)(*dataptr), *lenptr);
		*free_ptr = free;
	}
}

void
write_file(const char* filename, const unsigned char *data, int len)
{
	int fd = open(filename, O_CREAT | O_WRONLY, 0644);
	printf("opening %s for writing fd = %d (%d bytes)\n", filename,fd,len);
	if (fd > 0) {
		write(fd, (void *)data, len);
		close(fd);
	}
	return;
}
