/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */
#ifndef INCL_HFSC_HIERARCHY
#define INCL_HFSC_HIERARCHY



#include "hfsc_list.h"
#include "hfsc_req.h"
#include "hfsc_sc.h"
#include "hfsc_calheap.h"

#ifdef __cplusplus
extern "C" {
#endif

/* #define MAX_WORK        0x70000000 */
#define MAX_CLOCK         0x7F000000 
#define MAX_PACKET_LENGTH  0x1000000  /* in bits */
#define MAX_WORK        (MAX_CLOCK-MAX_PACKET_LENGTH)/COARSE_FACTOR
#define THRESHOLD_CLOCK 0x70000000

/***********************************************************
 * The structure of an item in the link-sharing hierarchy
 ************************************************************/ 

typedef struct _hfscClass {
	unsigned id;    /* item id; */
	unsigned type;  /* 
			 * specifies whether it is an internal or a leaf
			 * node in the hierarchy
			 */
	unsigned int    fActive; /* flag specifing whether the class is active or not */ 
	unsigned int    nBussy;  /*
				  * if this is an internal node in the class hierarchy,
				  * 'nBussy' represents the number of its active childern;
				  * if this is a leaf node, then it represents
				  * whether the session is active or not.
				  */
	unsigned long   vt;      /* virtual time */
	unsigned long   e;       /* eligible time (only for leaf classes) */
	unsigned long   d;       /* deadline (olny for leaf classes) */
	int   cWork;   /* 
			* cumulative work allocated to this class,
			* each time it was selected based on its
			* eligible time/deadline (only for leaf classes)
			*/
	int totalWork; /* total work allocated to this class */
	
	ServiceCurve    *pService;  /* class' service curve */
	RTServiceCurve  *pEligible; /* eligible curve */
	RTServiceCurve  *pDeadline; /* deadline curve */ 
	RTServiceCurve  *pVirtual;  /* virtual curve  */
	GenServiceCurve *pTotalSC;  /* aggregate service reserved by all children */
	
	struct _hfscClass *parent;     /* (pointer to) parent */
	struct _hfscClass *next;       /* next sibling */
	struct _hfscClass *pchildList; /* list of children */
#ifdef HFSC_CALENDAR
	CalPriorQueue     *pReqQueue;   /* children current requests */
#else
	Heap              *pReqQueue;   /* children current requests */
#endif
	ReqItem           *pFairReq;    /* 
					 * current request maintained in
					 * the parent's 'pReqQueue'
					 */
	ReqItem           *pGuarantReq; /* 
					 * current request maintained in
					 * the HFSCGlobal.pReqQueue list
					 */
	pkt_str          *dataQueue;
	
#ifdef FAST1
	int         idleTime;
#endif
	
} ClassItem;
	
	
/***********************************************************
 * The basic data structure for the hiererachical link-sharing 
 * data structure
 ************************************************************/ 
	
typedef struct {
	ClassItem     *proot;   /* root of the class hierarchy */
	CalHeapStruct *pReqQueue; /* 
				   * data structure maintaining the 
				   * requets by the eligible time and the 
				   * deadline
				   */
	unsigned int cnt;
} HFSCStruct;
	
#ifdef __cplusplus
}
#endif

#endif




