/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.javagroups.JChannel;
import org.javagroups.blocks.DistributedLockManager;
import org.javagroups.blocks.LockManager;
import org.javagroups.blocks.LockNotGrantedException;
import org.javagroups.blocks.LockNotReleasedException;
import org.javagroups.blocks.VotingAdapter;
import org.javagroups.log.Trace;

public class DistributedLockManagerTest
extends TestCase {
    public static final String SERVER_PROTOCOL_STACK = "UDP(mcast_addr=228.3.11.76;mcast_port=12345;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=500;num_initial_members=1):FD:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=200):FRAG(frag_size=4096):pbcast.GMS(join_timeout=5000;join_retry_timeout=1000;shun=false;print_local_addr=false)";
    protected static boolean logConfigured;
    private JChannel channel1;
    private JChannel channel2;
    protected VotingAdapter adapter1;
    protected VotingAdapter adapter2;
    protected LockManager lockManager1;
    protected LockManager lockManager2;
    static /* synthetic */ Class class$org$javagroups$blocks$DistributedLockManagerTest;

    public static Test suite() {
        Class clazz = class$org$javagroups$blocks$DistributedLockManagerTest;
        if (clazz == null) {
            clazz = class$org$javagroups$blocks$DistributedLockManagerTest = DistributedLockManagerTest.class$("[Lorg.javagroups.blocks.DistributedLockManagerTest;", false);
        }
        return new TestSuite(clazz);
    }

    public void setUp() throws Exception {
        Trace.init();
        this.channel1 = new JChannel(SERVER_PROTOCOL_STACK);
        this.adapter1 = new VotingAdapter(this.channel1);
        this.channel1.connect("voting");
        this.lockManager1 = new DistributedLockManager(this.adapter1, (Object)"1");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.channel2 = new JChannel(SERVER_PROTOCOL_STACK);
        this.adapter2 = new VotingAdapter(this.channel2);
        this.lockManager2 = new DistributedLockManager(this.adapter2, (Object)"2");
        this.channel2.connect("voting");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void tearDown() throws Exception {
        this.channel2.close();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.channel1.close();
    }

    public void test() throws Exception {
        this.lockManager1.lock("obj1", "owner1", 10000);
        try {
            this.lockManager1.lock("obj1", "owner2", 10000);
            DistributedLockManagerTest.assertTrue((String)"obj1 should not be locked.", (boolean)false);
        }
        catch (LockNotGrantedException ex) {
            // empty catch block
        }
        this.lockManager2.lock("obj2", "owner2", 1000);
        this.lockManager1.unlock("obj1", "owner1");
        try {
            this.lockManager1.unlock("obj2", "owner1");
            DistributedLockManagerTest.assertTrue((String)"obj2 should not be released.", (boolean)false);
        }
        catch (LockNotReleasedException lockNotReleasedException) {
            // empty catch block
        }
        this.lockManager1.unlock("obj2", "owner2");
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DistributedLockManagerTest.suite());
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DistributedLockManagerTest(String testName) {
        super(testName);
    }
}

