/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.debug;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class Profiler {
    private static OutputStream os = null;
    private static Hashtable entries = new Hashtable();

    public static void setFilename(String filename) {
        try {
            if (os != null) {
                os.close();
            }
            os = new FileOutputStream(filename);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void start(String call_name) {
        Entry e = (Entry)entries.get(call_name);
        if (e == null) {
            e = new Entry();
            entries.put(call_name, e);
        }
        e.start_time = System.currentTimeMillis();
    }

    public static void stop(String call_name) {
        Entry e = (Entry)entries.get(call_name);
        if (e == null) {
            System.err.println("Profiler.stop(): entry for " + call_name + " not found");
            return;
        }
        e.stop_time = System.currentTimeMillis();
        e.compute();
    }

    public static void dump() {
        if (os == null) {
            System.err.println("Profiler.dump(): output file is null");
            return;
        }
        try {
            os.write(new String("Key:      Number of calls:    Total time (ms): Average time (ms):\n").getBytes());
            os.write(new String("-----------------------------------------------------------------\n\n").getBytes());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        Enumeration e = entries.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Entry val = (Entry)entries.get(key);
            try {
                os.write(new String(key + ": " + val.num_calls + ' ' + val.tot_time + ' ' + Profiler.trim(val.avg) + '\n').getBytes());
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    public static double trim(double inp) {
        double retval = 0.0;
        double rem = 0.0;
        long l1 = (long)inp;
        rem = inp - (double)l1;
        long l2 = (long)(rem *= 100.0);
        rem = (double)l2 / 100.0;
        retval = (double)l1 + rem;
        return retval;
    }

    public static void main(String[] args) {
        Profiler.setFilename("bela.out");
        try {
            Profiler.start("time1");
            Thread.currentThread();
            Thread.sleep(1500L);
            Profiler.stop("time1");
            Profiler.start("time1");
            Thread.currentThread();
            Thread.sleep(1500L);
            Profiler.start("time2");
            Thread.currentThread();
            Thread.sleep(500L);
            Profiler.stop("time2");
            Thread.currentThread();
            Thread.sleep(1500L);
            Profiler.stop("time1");
            Profiler.dump();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public Profiler() {
        try {
            os = new FileOutputStream("profiler.dat");
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Entry {
        long num_calls;
        long tot_time;
        double avg;
        long start_time;
        long stop_time;

        synchronized void compute() {
            ++this.num_calls;
            this.tot_time += this.stop_time - this.start_time;
            this.avg = (double)this.tot_time / (double)this.num_calls;
        }

        private final /* synthetic */ void this() {
            this.num_calls = 0L;
            this.tot_time = 0L;
            this.avg = 0.0;
            this.start_time = 0L;
            this.stop_time = 0L;
        }

        public Entry() {
            this.this();
        }
    }
}

