/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.pbcast.Digest;
import org.javagroups.protocols.pbcast.NakAckHeader;
import org.javagroups.stack.NakReceiverWindow;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.Retransmitter;
import org.javagroups.util.Range;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NAKACK
extends Protocol
implements Retransmitter.RetransmitCommand {
    long[] retransmit_timeout;
    boolean is_server;
    Address local_addr;
    Vector members;
    long seqno;
    long deleted_up_to;
    long max_xmit_size;
    int gc_lag;
    Hashtable received_msgs;
    Hashtable sent_msgs;
    boolean leaving;
    TimeScheduler timer;

    public String getName() {
        return "NAKACK";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(57));
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(53));
        return retval;
    }

    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(57));
        return retval;
    }

    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("NAKACK.up(): timer is null");
        }
    }

    public void stop() {
        if (this.timer != null) {
            try {
                this.timer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.removeAll();
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                this.send(msg);
                return;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigest();
                this.passUp(new Event(40, digest));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passUp(new Event(58, digest));
                return;
            }
            case 42: {
                Digest digest = this.getDigest();
                this.passUp(new Event(43, digest));
                return;
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return;
            }
            case 56: {
                this.passDown(evt);
                if (Trace.trace) {
                    Trace.info("NAKACK.down()", "received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 15: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.removeAllElements();
                this.members.addAll(mbrs);
                this.adjustReceivers();
                break;
            }
            case 6: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.removeAllElements();
                this.members.addAll(mbrs);
                this.adjustReceivers();
                this.is_server = true;
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 4: {
                this.leaving = true;
                this.removeAll();
                this.seqno = 0L;
                break;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(40, digest));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(58, digest));
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 56: {
                this.passUp(evt);
                if (Trace.trace) {
                    Trace.info("NAKACK.up()", "received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof NakAckHeader)) break;
                if (!this.is_server) {
                    if (Trace.trace) {
                        Trace.debug("NAKACK.up()", "message was discarded (not yet server)");
                    }
                    return;
                }
                NakAckHeader hdr = (NakAckHeader)obj;
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (Trace.trace) {
                                Trace.error("NAKACK.up()", "XMIT_REQ: range of xmit msg == null; discarding request from " + msg.getSrc());
                            }
                            return;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high);
                        return;
                    }
                    case 3: {
                        this.handleXmitRsp(msg);
                        return;
                    }
                }
                Trace.error("NAKACK.up()", "NakAck header type " + hdr.type + " not known !");
                return;
            }
        }
        this.passUp(evt);
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeout = tmp;
            }
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = new Integer(str);
            if (this.gc_lag < 1) {
                System.err.println("NAKACK.setProperties(): gc_lag has to be at least 1 (set to 10)");
                this.gc_lag = 10;
            }
            props.remove("gc_lag");
        }
        if ((str = props.getProperty("max_xmit_size")) != null) {
            this.max_xmit_size = Long.parseLong(str);
            props.remove("max_xmit_size");
        }
        if (props.size() > 0) {
            System.err.println("NAKACK.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    long getNextSeqno() {
        return this.seqno++;
    }

    void send(Message msg) {
        long msg_id = this.getNextSeqno();
        msg.putHeader(this.getName(), new NakAckHeader(1, msg_id));
        this.sent_msgs.put(new Long(msg_id), msg);
        this.passDown(new Event(1, msg));
    }

    void handleMessage(Message msg, NakAckHeader hdr) {
        Message msg_to_deliver;
        NakReceiverWindow win = null;
        if (msg == null || hdr == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.handleMessage()", "msg or header is null");
            }
            return;
        }
        Address sender = msg.getSrc();
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.handleMessage()", "sender of message is null");
            }
            return;
        }
        win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            if (this.leaving) {
                return;
            }
            if (Trace.trace) {
                Trace.warn("NAKACK.handleMessage()", "[" + this.local_addr + "] discarded message from non-member " + sender);
            }
            return;
        }
        win.add(hdr.seqno, msg);
        while ((msg_to_deliver = win.remove()) != null) {
            this.passUp(new Event(1, msg_to_deliver));
        }
    }

    void handleXmitReq(Address dest, long first_seqno, long last_seqno) {
        long size = 0L;
        long marker = first_seqno;
        if (first_seqno > last_seqno) {
            Trace.error("NAKACK.handleXmitReq()", "first_seqno (" + first_seqno + ") > last_seqno (" + last_seqno + "): not able to retransmit");
            return;
        }
        ArrayList<Message> list = new ArrayList<Message>();
        long i = first_seqno;
        while (i <= last_seqno) {
            Message m = (Message)this.sent_msgs.get(new Long(i));
            if (m == null) {
                Trace.error("NAKACK.handleXmitReq()", "(requester=" + dest + ") message with seqno=" + i + " not found in sent_msgs ! sent_msgs=" + this.printSentMsgs());
            } else {
                if ((size += m.size()) >= this.max_xmit_size) {
                    if (Trace.trace) {
                        Trace.debug("NAKACK.handleXmitReq()", "xmitting msgs [" + marker + '-' + (i - 1L) + "] to " + dest);
                    }
                    this.sendXmitRsp(new Message(dest, null, (ArrayList)list.clone()), marker, i - 1L);
                    marker = i;
                    list.clear();
                    size = 0L;
                }
                Message tmp = m;
                tmp.setDest(dest);
                tmp.setSrc(this.local_addr);
                list.add(tmp);
            }
            ++i;
        }
        if (list.size() > 0) {
            if (Trace.trace) {
                Trace.debug("NAKACK.handleXmitReq()", "xmitting msgs [" + marker + '-' + last_seqno + "] to " + dest);
            }
            this.sendXmitRsp(new Message(dest, null, (ArrayList)list.clone()), marker, last_seqno);
        }
    }

    void sendXmitRsp(Message msg, long first_seqno, long last_seqno) {
        msg.putHeader(this.getName(), new NakAckHeader(3, first_seqno, last_seqno));
        this.passDown(new Event(1, msg));
    }

    void handleXmitRsp(Message msg) {
        if (msg == null) {
            Trace.warn("NAKACK.handleXmitRsp()", "message is null");
            return;
        }
        try {
            ArrayList list = (ArrayList)msg.getObject();
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Message m = (Message)it.next();
                    this.up(new Event(1, m));
                }
            }
        }
        catch (Exception ex) {
            Trace.error("NAKACK.handleXmitRsp()", "message did not contain a list (ArrayList) of retransmitted messages: " + ex);
        }
    }

    void adjustReceivers() {
        NakReceiverWindow win;
        Address sender;
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            sender = (Address)e.nextElement();
            if (this.members.contains(sender)) continue;
            win = (NakReceiverWindow)this.received_msgs.get(sender);
            win.reset();
            if (Trace.trace) {
                Trace.info("NAKACK.adjustReceivers()", "removing " + sender + " from received_msgs (not member anymore)");
            }
            this.received_msgs.remove(sender);
        }
        int i = 0;
        while (i < this.members.size()) {
            sender = (Address)this.members.elementAt(i);
            if (!this.received_msgs.containsKey(sender)) {
                win = new NakReceiverWindow(sender, this, 0L, this.timer);
                win.setRetransmitTimeouts(this.retransmit_timeout);
                this.received_msgs.put(sender, win);
            }
            ++i;
        }
    }

    Digest getDigest() {
        Digest digest = new Digest(this.members.size());
        int i = 0;
        while (i < this.members.size()) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, false);
            if (range == null) {
                if (Trace.trace) {
                    Trace.error("NAKACK.getDigest()", "range is null");
                }
            } else {
                digest.add(sender, range.low, range.high);
            }
            ++i;
        }
        return digest;
    }

    Digest getDigestHighestDeliveredMsgs() {
        long high_seqno_seen = 0L;
        Digest digest = new Digest(this.members.size());
        int i = 0;
        while (i < this.members.size()) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, true);
            if (range == null) {
                if (Trace.trace) {
                    Trace.error("NAKACK.getDigest()", "range is null");
                }
            } else {
                high_seqno_seen = this.getHighSeqnoSeen(sender);
                digest.add(sender, range.low, range.high, high_seqno_seen);
            }
            ++i;
        }
        return digest;
    }

    void setDigest(Digest d) {
        this.clear();
        if (d == null || d.senders == null) {
            Trace.error("NAKACK.setDigest()", "digest or digest.senders is null");
            return;
        }
        int i = 0;
        while (i < d.size()) {
            Address sender = d.senderAt(i);
            if (sender == null) {
                Trace.error("NAKACK.setDigest()", "sender at index " + i + " in digest is null");
            } else {
                long initial_seqno = d.highSeqnoAt(i);
                NakReceiverWindow win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                win.setRetransmitTimeouts(this.retransmit_timeout);
                this.received_msgs.put(sender, win);
            }
            ++i;
        }
    }

    void mergeDigest(Digest d) {
        if (d == null || d.senders == null) {
            Trace.error("NAKACK.mergeDigest()", "digest or digest.senders is null");
            return;
        }
        int i = 0;
        while (i < d.size()) {
            Address sender = d.senderAt(i);
            if (sender == null) {
                Trace.error("NAKACK.mergeDigest()", "sender at index " + i + " in digest is null");
            } else {
                long initial_seqno = d.highSeqnoAt(i);
                NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (win == null) {
                    win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                    win.setRetransmitTimeouts(this.retransmit_timeout);
                    this.received_msgs.put(sender, win);
                } else if (win.getHighestReceived() < initial_seqno) {
                    win.reset();
                    this.received_msgs.remove(sender);
                    win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                    win.setRetransmitTimeouts(this.retransmit_timeout);
                    this.received_msgs.put(sender, win);
                }
            }
            ++i;
        }
    }

    Range getLowestAndHighestSeqno(Address sender, boolean stop_at_gaps) {
        Range r = null;
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.getLowestAndHighestSeqno()", "sender is null");
            }
            return r;
        }
        NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            Trace.error("NAKACK.getLowestAndHighestSeqno()", "sender " + sender + " not found in received_msgs");
            return r;
        }
        r = stop_at_gaps ? new Range(win.getLowestSeen(), win.getHighestSeen()) : new Range(win.getLowestSeen(), win.getHighestReceived() + 1L);
        return r;
    }

    long getHighSeqnoSeen(Address sender) {
        long ret = 0L;
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.getHighSeqnoSeen()", "sender is null");
            }
            return ret;
        }
        if (sender.equals(this.local_addr)) {
            return this.seqno - 1L;
        }
        NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            Trace.error("NAKACK.getHighSeqnoSeen()", "sender " + sender + " not found in received_msgs");
            return ret;
        }
        ret = win.getHighestReceived();
        return ret;
    }

    void stable(Digest d) {
        if (this.members == null || this.local_addr == null || d == null) {
            if (Trace.trace) {
                Trace.warn("NAKACK.stable()", "members, local_addr or digest are null !");
            }
            return;
        }
        if (Trace.trace) {
            Trace.info("NAKACK.stable()", "received digest " + d);
        }
        int i = 0;
        while (i < d.size()) {
            Address sender = d.senderAt(i);
            long seqno = d.highSeqnoAt(i);
            if (sender != null) {
                NakReceiverWindow recv_win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (recv_win != null) {
                    long my_highest_rcvd = recv_win.getHighestReceived();
                    long stability_highest_rcvd = d.highSeqnoSeenAt(i);
                    if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                        if (Trace.trace) {
                            Trace.debug("NAKACK.stable()", "my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + sender + '#' + stability_highest_rcvd);
                        }
                        this.retransmit(stability_highest_rcvd, stability_highest_rcvd, sender);
                    }
                }
                if ((seqno -= (long)this.gc_lag) >= 0L) {
                    if (Trace.trace) {
                        Trace.info("NAKACK.stable()", "deleting stable msgs < " + sender + '#' + seqno);
                    }
                    if (sender.equals(this.local_addr)) {
                        if (Trace.trace) {
                            Trace.info("NAKACK.stable()", "removing [" + this.deleted_up_to + " - " + seqno + "] from sent_msgs");
                        }
                        long j = this.deleted_up_to;
                        while (j <= seqno) {
                            this.sent_msgs.remove(new Long(j));
                            ++j;
                        }
                        this.deleted_up_to = seqno;
                    }
                    if (recv_win != null) {
                        recv_win.stable(seqno);
                    }
                }
            }
            ++i;
        }
    }

    public synchronized void retransmit(long first_seqno, long last_seqno, Address sender) {
        Message retransmit_msg = new Message(sender, null, null);
        if (Trace.trace) {
            Trace.info("NAKACK.retransmit()", "sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + sender);
        }
        NakAckHeader hdr = new NakAckHeader(2, first_seqno, last_seqno);
        retransmit_msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, retransmit_msg));
    }

    void clear() {
        this.sent_msgs.clear();
        Enumeration e = this.received_msgs.elements();
        while (e.hasMoreElements()) {
            NakReceiverWindow win = (NakReceiverWindow)e.nextElement();
            win.reset();
        }
        this.received_msgs.clear();
    }

    void removeAll() {
        this.sent_msgs.clear();
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(key);
            win.destroy();
        }
        this.received_msgs.clear();
    }

    String dumpContents() {
        StringBuffer ret = new StringBuffer();
        ret.append("\nsent_msgs: " + this.sent_msgs.size());
        ret.append("\nreceived_msgs: ");
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            NakReceiverWindow w = (NakReceiverWindow)this.received_msgs.get(key);
            ret.append("\n" + w.toString());
        }
        return ret.toString();
    }

    String printSentMsgs() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.sent_msgs.keys();
        while (e.hasMoreElements()) {
            sb.append("" + e.nextElement() + ' ');
        }
        return sb.toString();
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.max_xmit_size = ((Integer)map.get("frag_size")).intValue();
            if (Trace.trace) {
                Trace.info("NAKACK.handleConfigEvent()", "max_xmit_size=" + this.max_xmit_size);
            }
        }
    }

    private final /* synthetic */ void this() {
        this.retransmit_timeout = new long[]{600L, 1200L, 2400L, 4800L};
        this.is_server = false;
        this.local_addr = null;
        this.members = new Vector();
        this.seqno = 0L;
        this.deleted_up_to = 0L;
        this.max_xmit_size = 8192L;
        this.gc_lag = 20;
        this.received_msgs = new Hashtable();
        this.sent_msgs = new Hashtable();
        this.leaving = false;
        this.timer = null;
    }

    public NAKACK() {
        this.this();
    }
}

