--TEST--
maxdb bind_result (OO-Style) 
--SKIPIF--
<?php require 'skipifoo.inc'; ?>
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$maxdb = maxdb_connect("localhost", $user, $passwd);

	$maxdb->select_db($db);		

        maxdb_report (MAXDB_REPORT_OFF);
	$maxdb->query("DROP TABLE test_fetch_null");
        maxdb_report (MAXDB_REPORT_ERROR);

  	$maxdb->query("CREATE TABLE test_fetch_null(col1 integer, col2 smallint,
                                                    col3 integer, col4 fixed(20), 
                                                    col5 float, col6 fixed(10,4),
                                                    col7 date, col8 time, 
                                                    col9 varchar(10) byte, 
                                                    col10 varchar(50),
                                                    col11 char(20))");


	$maxdb->query("INSERT INTO test_fetch_null(col1,col10, col11) VALUES(1,'foo1', 1000)");
        $maxdb->query("INSERT INTO test_fetch_null(col1,col10, col11) VALUES(2,'foo2', 88)");
        $maxdb->query("INSERT INTO test_fetch_null(col1,col10, col11) VALUES(3,'foo3', 389789)");

	$stmt = $maxdb->prepare("SELECT col1, col2, col3, col4, col5, col6, col7, col8, col9, col10, col11 from test_fetch_null");
	$stmt->bind_result($c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8, $c9, $c10, $c11); 
	$stmt->execute();

	$stmt->fetch();

	$test = array($c1,$c2,$c3,$c4,$c5,$c6,$c7,$c8,$c9,$c10,$c11);

	var_dump($test);

	$stmt->close();
	$maxdb->close();
?>
--EXPECT--
array(11) {
  [0]=>
  int(1)
  [1]=>
  NULL
  [2]=>
  NULL
  [3]=>
  NULL
  [4]=>
  NULL
  [5]=>
  NULL
  [6]=>
  NULL
  [7]=>
  NULL
  [8]=>
  NULL
  [9]=>
  string(4) "foo1"
  [10]=>
  string(4) "1000"
}
