  /*  term.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include "powershell.h"

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>

int prev_x, prev_y;
int size_x,  size_y;

enum targets_enum {
  TARGET_STRING,
  TARGET_COLOR
};

void term_resize (GtkWidget * widget, GdkEvent * event, gpointer callback_data);

color_settings ColorPrefs;

/* These palettes were shamelessly stolen from gnome-terminal */

gushort linux_red[] = { 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa,
                        0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff,
                        0x0,    0x0 };
gushort linux_grn[] = { 0x0000, 0x0000, 0xaaaa, 0x5555, 0x0000, 0x0000, 0xaaaa, 0xaaaa,
                        0x5555, 0x5555, 0xffff, 0xffff, 0x5555, 0x5555, 0xffff, 0xffff,
                        0x0,    0x0 };
gushort linux_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa,
                        0x5555, 0x5555, 0x5555, 0x5555, 0xffff, 0xffff, 0xffff, 0xffff,
                        0x0,    0x0 };

gushort xterm_red[] = { 0x0000, 0x6767, 0x0000, 0x6767, 0x0000, 0x6767, 0x0000, 0x6868,
                        0x2a2a, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
                        0x0,    0x0 };

gushort xterm_grn[] = { 0x0000, 0x0000, 0x6767, 0x6767, 0x0000, 0x0000, 0x6767, 0x6868,
                        0x2a2a, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
                        0x0,    0x0 };
gushort xterm_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x6767, 0x6767, 0x6767, 0x6868,
                        0x2a2a, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
                        0x0,    0x0 };

gushort rxvt_red[] = { 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
                       0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
                        0x0,    0x0 };
gushort rxvt_grn[] = { 0x0000, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
                       0x0000, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
                        0x0,    0x0 };
gushort rxvt_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
                       0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
                        0x0,    0x0 };

GtkWidget * rd_dialog;
GtkWidget * rd_hbox1, * rd_label1, * rd_termname;
GtkWidget * nblabel;

GtkFontSelectionDialog * fontsel;

void DisconnectTerm ()
{
  
}

void windowmoved (GtkWidget * widget, gpointer data)
{
  ZvtTerm * curterm;

  if (Prefs.transparent)
    {
      curterm = get_nth_zvt (GTK_NOTEBOOK(notebook), 
			     gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)));
      gtk_widget_queue_draw (GTK_WIDGET(curterm));
    }
}

void UpdateTerm (ZvtTerm * term)
{
  zvt_term_set_background (ZVT_TERM (term), Prefs.use_pixmap ? Prefs.bg_pixmap : NULL, 
			   Prefs.transparent, Prefs.shaded ? 1 : 0);
  
  zvt_term_set_font_name(ZVT_TERM (term), Prefs.font);
  zvt_term_set_scrollback(ZVT_TERM (term), scrollbacklines);
  zvt_term_set_blink (ZVT_TERM (term), ColorPrefs.blink);
  zvt_term_set_bell (ZVT_TERM (term), ColorPrefs.bell);

  set_color_scheme (ZVT_TERM(term), ColorPrefs);


  zvt_term_set_scroll_on_keystroke (ZVT_TERM (term), ColorPrefs.scroll_keystroke);
  zvt_term_set_scroll_on_output (ZVT_TERM (term), ColorPrefs.scroll_output);

#ifdef ZVT_USE_MATCHING
  zvt_term_match_clear (ZVT_TERM(term), NULL);  
  if (Prefs.use_matching)
    {  
      zvt_term_match_add (ZVT_TERM(term), "http\\:\\/\\/([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "http");
      zvt_term_match_add (ZVT_TERM(term), "www\\.([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "http");
      zvt_term_match_add (ZVT_TERM(term), "ftp\\:\\/\\/([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "ftp");
      zvt_term_match_add (ZVT_TERM(term), "ftp\\.([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "ftp");
      zvt_term_match_add (ZVT_TERM(term), "([a-z]|[A-Z]|[0-9]|\\_|\\.|\\-|\\+)*\\@([a-z]|[A-Z]|[0-9]|\\_|\\.|\\-|\\+)*", VTATTR_UNDERLINE, "mailto");
      zvt_term_match_add (ZVT_TERM(term), "telnet\\:\\/\\/([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "telnet");
    }
  
#endif

  gtk_widget_queue_draw (GTK_WIDGET(term));
}

ZvtTerm * get_nth_zvt (GtkNotebook * notebook, gint n)
{
  GtkWidget * hbox;
  GList * child;
  GtkWidget * ch;

  hbox = gtk_notebook_get_nth_page (GTK_NOTEBOOK(notebook), n);
  if (!hbox)
    return NULL;

  child = GTK_BOX(hbox)->children;
  
  while (child)
    {
      ch = ((GtkBoxChild *)(child->data))->widget;
      if (GTK_WIDGET_TYPE(ch) != gtk_vscrollbar_get_type())
	return ZVT_TERM(ch);
    }
  return NULL;
}

void UpdateAllTerms ()
{
  GList * child;
  GtkWidget * ch;
  GtkWidget * hbox;
  int a=0;
  
  while (ch = get_nth_zvt(GTK_NOTEBOOK(notebook),a))
    {
      UpdateTerm (ZVT_TERM(ch));
      a++;
    }
  
  

}


void store_font (GtkFontSelectionDialog * b, gpointer user_data)
{
  gchar * fontname = gtk_font_selection_dialog_get_font_name (fontsel);
  ZvtTerm * t;
  int a = 0;
  strcpy (Prefs.font, fontname);
  WriteRCFile();

  while (t = get_nth_zvt (GTK_NOTEBOOK(notebook), a))
    {
      zvt_term_set_size (t, prev_x, prev_y);

      a++;
    }
  

  UpdateAllTerms();

}


void FontSel ()
{
  gchar * spacings[] = {"c", "n", NULL};
  ZvtTerm * term;

  term = get_nth_zvt (GTK_NOTEBOOK(notebook), 0);
  prev_x = term->grid_width;
  prev_y = term->grid_height;

  fontsel = GTK_FONT_SELECTION_DIALOG(gtk_font_selection_dialog_new ("Choose Font"));

  gtk_font_selection_dialog_set_font_name (fontsel, Prefs.font);

  gtk_font_selection_dialog_set_filter (GTK_FONT_SELECTION_DIALOG (fontsel),
					GTK_FONT_FILTER_BASE, GTK_FONT_ALL,
					NULL, NULL, NULL, NULL, spacings, NULL);

  gtk_signal_connect (GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontsel)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (store_font), NULL);

  gtk_signal_connect_object (GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontsel)->cancel_button),
		      "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      (gpointer) fontsel);

  gtk_signal_connect_object (GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontsel)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      (gpointer) fontsel);

  gtk_widget_show (GTK_WIDGET(fontsel));
  

}

void rd_ok_clicked (gchar * newname, gpointer data)
{
  if (!newname)
    return;
  gtk_label_set (GTK_LABEL(nblabel),
		 newname);
  free (newname);
}

void QuickMessage (gchar * message)
{
  GtkWidget *dialog, *label, *okay_button;
  
  dialog = gtk_dialog_new();
  label = gtk_label_new (message);
  okay_button = gtk_button_new_with_label("Ok");
  
  gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(dialog));
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		     okay_button);
  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
		     label);
  gtk_widget_show_all (dialog);
}

void RenameTerm2()
{
  QuickMessage ("You can also rename a tab by right-clicking\n\
on the terminal window.");
  RenameTerm();

}

void RenameTerm()
{
  gchar * curtermname;

  nblabel = gtk_notebook_get_tab_label (GTK_NOTEBOOK(notebook),
              gtk_notebook_get_nth_page (GTK_NOTEBOOK(notebook),
	      gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook))));

  gtk_label_get (GTK_LABEL(nblabel), (gchar **)(&curtermname));

  gnome_request_dialog (FALSE, "Rename Tab", curtermname, 128,
			    rd_ok_clicked, NULL, GTK_WINDOW(window));

}

void run_ok_clicked (gchar * newname, gpointer data)
{
  gchar command[512], args[512];
  char * tmp;

  if (!newname)
    return;   

  bzero (command, 512);
  bzero (args, 512);

  tmp = strstr (newname, " ");
  if (!tmp)
    strcpy (command, newname);
  else
    {
      *tmp = '\0';
	  strcpy (command, newname);
	  *tmp = ' ';
	  tmp++;
	  strcpy (args, tmp);
    }

  new_term (GTK_WIDGET(notebook), command, args, command);
	  
  free (newname);
}

void RunArbitrary()
{
  gchar * curtermname;

  nblabel = gtk_notebook_get_tab_label (GTK_NOTEBOOK(notebook),
              gtk_notebook_get_nth_page (GTK_NOTEBOOK(notebook),
	      gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook))));

  gtk_label_get (GTK_LABEL(nblabel), (gchar **)(&curtermname));

  gnome_request_dialog (FALSE, "Run...", "", 128,
			run_ok_clicked, NULL, GTK_WINDOW(window));
}

void PrepareArgs (char * command, char * args, char *** arg_array)
{
  int num;
  char * tmp;
  char * tmp2;

  char * cn;
  int a;
  char * args_cpy;
  int run_background = 0;
  FILE * bgrun_script;
  char *tmp_filename;
  char buf[512];

  tmp = strstr (args, "&");
  tmp_filename = (char *)malloc (256);

  run_background = (tmp == args + strlen(args)-1);

  if (run_background)
    /* execute this code if the command ends in a & 
     * not sure if there's another way to run it in the background.
     * there must be, though.  Well, i'll replace it when I find out.
     */
    {
      sprintf (buf, "%s %s", command, args);
      system (buf);
      *arg_array = NULL;
      return;
    }

  tmp = strstr (command, "/");

  if (!tmp)
    {
      QuickMessage ("You must include the full path to all programs you run!");
      return;
    }

  tmp++;
  while (strstr (tmp, "/"))
    {
      tmp = strstr (tmp, "/")+1;
    }
  
  cn = (char *)malloc (strlen (tmp) + 1);
  
  strcpy (cn, tmp);

  if (strlen (args) == 0)
    {
      *arg_array = (char **)malloc (sizeof(char *) * 2);
      (*arg_array)[0] = (char *)malloc (strlen (cn) + 1);
      strcpy ((*arg_array)[0], cn);
      (*arg_array)[1] = NULL;
      return;
    }

  num = 1;

  args_cpy = (char *)malloc (strlen (args) + 1);
  strcpy (args_cpy, args);

  tmp = strstr (args_cpy, " ");
  if (tmp)
    {
      while (strstr (tmp, " "))
	{
	  tmp = strstr (tmp, " ") + 1;
	  num ++;
	}
    }

  *arg_array = (char **)malloc (sizeof(char *) * (2+num));
  (*arg_array)[0] = (char *)malloc (strlen (cn) + 1);
  strcpy ((*arg_array)[0], cn);

  tmp = args_cpy;

  for (a=0;a<num;a++)
    {
      tmp2 = strstr (tmp, " ");
      if (tmp2)
	tmp2[0] = '\0';

      (*arg_array)[a+1] = (char *)malloc (strlen(tmp) + 1);
      strcpy ((*arg_array)[a+1], tmp);
      if (tmp2)
	tmp2[0] = ' ';
      tmp = strstr (tmp, " ") +1;
    }

  (*arg_array)[num+1] = NULL;
}

void set_color_scheme (ZvtTerm * term, color_settings cs)
{
  gushort bak[3][2];
  int a;
  bak[0][0] = cs.red[16];
  bak[1][0] = cs.green[16];
  bak[2][0] = cs.blue[16];
  
  bak[0][1] = cs.red[17];
  bak[1][1] = cs.green[17];
  bak[2][1] = cs.blue[17];
  
  cs.red[16] = cs.fg[0];
  cs.green[16] = cs.fg[1];
  cs.blue[16] = cs.fg[2];

  cs.red[17] = cs.bg[0];
  cs.green[17] = cs.bg[1];
  cs.blue[17] = cs.bg[2];

  zvt_term_set_color_scheme (term, cs.red, cs.green, cs.blue);
  /*  gtk_widget_queue_draw (GTK_WIDGET(term));*/

  cs.red[16] = bak[0][0];
  cs.green[16] = bak[1][0];
  cs.blue[16] = bak[2][0];

  cs.red[17] = bak[0][1];
  cs.green[17] = bak[1][1];
  cs.blue[17] = bak[2][1];

}

GtkWidget * new_term (GtkWidget * notebook, gchar * command, gchar * args, gchar * title)
{

  return (new_term_x (notebook, command, args, title, -1, -1));
}

GtkWidget * new_term_x (GtkWidget * notebook, gchar * command, gchar * args, gchar * title, int w, int h)
{
  GtkWidget *term, *scrollbar;
  enum { RIGHT, LEFT } scrollpos = LEFT;
  GString *shell, *name;
  GtkWidget * label;
  struct passwd *pw;
  gushort * colors, red[18], green[18], blue[18];
  int a,b;
  char tmp[512];
  char ** arg_array;
  GtkWidget * hbox;


  struct stat * sanity_check;
  
  sanity_check = (struct stat *)malloc (sizeof(struct stat));

  if (!notebook || !command || !args || !title)
    return NULL;
  
  if (get_nth_zvt(GTK_NOTEBOOK(notebook),0))
    {
      w = ZVT_TERM(get_nth_zvt(GTK_NOTEBOOK(notebook),0))->grid_width;
      h = ZVT_TERM(get_nth_zvt(GTK_NOTEBOOK(notebook),0))->grid_height;
    }
  else
    {
      w = size_x;
      h = size_y;
    }

  PrepareArgs (command, args, &arg_array);

  if (!arg_array)
    {
      return NULL;
    }

  terms_open ++;
  
  if (Prefs.hidetabswhensingle)
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK(notebook), terms_open > 1);

  /* create terminal */
  
  w++;

  if ((w > 0) && (h > 0))
    term = zvt_term_new_with_size(w,h);
  else
    term = zvt_term_new();
  
  
  if (!term)
    {
      fprintf (stderr, "Error creating new terminal\n");
      return NULL;
    }

  zvt_term_set_background (ZVT_TERM (term), Prefs.use_pixmap ? Prefs.bg_pixmap : NULL, 
			 Prefs.transparent, Prefs.shaded ? 1 : 0);

  zvt_term_set_font_name(ZVT_TERM (term), Prefs.font);
  zvt_term_set_blink (ZVT_TERM (term), ColorPrefs.blink);
  zvt_term_set_bell (ZVT_TERM (term), ColorPrefs.bell);
  zvt_term_set_scrollback(ZVT_TERM (term), scrollbacklines);
  zvt_term_set_scroll_on_keystroke (ZVT_TERM (term), ColorPrefs.scroll_keystroke);
  zvt_term_set_scroll_on_output (ZVT_TERM (term), ColorPrefs.scroll_output);

  zvt_term_set_wordclass (ZVT_TERM (term), "-A-Za-z0-9/_:.,?+%=");
  zvt_term_set_del_key_swap (ZVT_TERM (term), ColorPrefs.del_bs_switch);
  
  /* fork the shell/program */
  switch (zvt_term_forkpty(ZVT_TERM (term), ZVT_TERM_DO_UTMP_LOG |  
			   ZVT_TERM_DO_WTMP_LOG))
    {
    case -1:
      perror("ERROR: unable to fork:");
      return NULL;
      break;
      
    case 0:
      if (stat (command, sanity_check))
	{
	  /* i do the exec here so that it cleans up the zterm properly */
	  /*  QuickMessage ("The specified program does not exist.");*/
	  execle ("/bin/sh", "sh", "-c", "echo The specified program does not exist", NULL, env_copy);
	  if (!title)
	    {
	      title = (char *)malloc(1);
	      title[0]='\0';
	    }
	} 
      
      if (!(sanity_check->st_mode & S_IXUSR))
	{
	  /*	  QuickMessage ("Permission denied.");*/
	  execle ("/bin/sh", "sh", "-c", "echo Permission denied", NULL, env_copy);
	  if (!title)
	    {
	      title = (char *)malloc(1);
	      title[0]='\0';
	    }
	}

      execve (command, arg_array, env_copy);
      break;
      
    default:
      break;
    }
  
  label = gtk_label_new (title);

  scrollbar = gtk_vscrollbar_new (GTK_ADJUSTMENT (ZVT_TERM(term)->adjustment));
  
  GTK_WIDGET_UNSET_FLAGS (scrollbar, GTK_CAN_FOCUS);
  GTK_WIDGET_UNSET_FLAGS (notebook, GTK_CAN_FOCUS);

  hbox = gtk_hbox_new (FALSE, 0);

  switch (Prefs.scrollbarpos)
    {
    case 0:
      gtk_box_pack_start(GTK_BOX (hbox), term, TRUE, TRUE, 0);  
      gtk_box_pack_start(GTK_BOX (hbox), scrollbar, FALSE, FALSE, 0);
      gtk_widget_show (scrollbar);
      break;
    case 1:
      gtk_box_pack_start (GTK_BOX(hbox), scrollbar, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX(hbox), term, TRUE, TRUE, 0);
      gtk_widget_show (scrollbar);
      break;
    case 2:
      gtk_box_pack_start (GTK_BOX(hbox), term, TRUE, TRUE, 0);
      break;
    }

  gtk_widget_show (hbox);
  gtk_widget_show (GTK_WIDGET(term));
  gtk_widget_show (GTK_WIDGET(label));

  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), hbox, label);
  gtk_notebook_set_page (GTK_NOTEBOOK(notebook), -1);
  
  gtk_signal_connect (GTK_OBJECT (term),
		      "child_died",
		      GTK_SIGNAL_FUNC (child_died_event),
		      NULL);
  
  gtk_signal_connect (GTK_OBJECT (term),
		      "destroy",
		      GTK_SIGNAL_FUNC (term_died_event),
		      NULL);
  
  gtk_signal_connect (GTK_OBJECT (term),
		      "title_changed",
		      GTK_SIGNAL_FUNC (title_changed_event),
		      NULL);
  
  gtk_signal_connect_after (GTK_OBJECT (term),
			    "realize",
			    GTK_SIGNAL_FUNC (set_hints),
			    term);

  gtk_signal_connect (GTK_OBJECT (window),
		      "key-press-event",
		      GTK_SIGNAL_FUNC (term_key_event),
		      NULL);

  gtk_signal_connect (GTK_OBJECT (term),
		      "button_press_event",
		      GTK_SIGNAL_FUNC (term_click_event),
		      NULL);

  gtk_signal_connect (GTK_OBJECT (term), "size-allocate", GTK_SIGNAL_FUNC (term_resize),
		      NULL);

#ifdef ZVT_USE_MATCHING
  if (Prefs.use_matching)
    {  
      zvt_term_match_add (ZVT_TERM(term), "http\\:\\/\\/([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "http");
      zvt_term_match_add (ZVT_TERM(term), "www\\.([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "http");
      zvt_term_match_add (ZVT_TERM(term), "ftp\\:\\/\\/([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "ftp");
      zvt_term_match_add (ZVT_TERM(term), "ftp\\.([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "ftp");
      zvt_term_match_add (ZVT_TERM(term), "([a-z]|[A-Z]|[0-9]|\\_|\\.|\\-|\\+)*\\@([a-z]|[A-Z]|[0-9]|\\_|\\.|\\-|\\+)*", VTATTR_UNDERLINE, "mailto");
      zvt_term_match_add (ZVT_TERM(term), "telnet\\:\\/\\/([a-z]|[A-Z]|[0-9]|\\_|\\.|\\&|\\%|\\@|\\?|\\-|\\~|\\/|\\=|\\+|\\:)*", VTATTR_UNDERLINE, "telnet");
    }
#endif

  gtk_drag_dest_set (GTK_WIDGET(term), GTK_DEST_DEFAULT_ALL,
		     target_table, 1, GDK_ACTION_COPY);

  gtk_signal_connect (GTK_OBJECT(term), "drag_data_received",
		      GTK_SIGNAL_FUNC (drag_data_received), NULL);


  gtk_container_set_border_width (GTK_CONTAINER(hbox), 0);

  
  if (window_shown)
    set_color_scheme (ZVT_TERM(term), ColorPrefs);


  return term;
}







