########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Commands/Log/Clear.py,v 1.10 2004/02/01 03:09:25 jkloth Exp $
"""
4ss_manager log clear command

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """Clear the logs"""

def Run(options, args):
    import time, sys, os
    from Ft.Server.Server.Commands.CommandUtil import GetRepository

    username, password, properties, repo = \
              GetRepository(options, '4ss_manager.log.view')
    repo.txRollback()

    logfile = properties['LogFile']
    prompt = "Are you sure you want to clear %r? (yes/no) " % logfile
    answer = raw_input(prompt)
    if answer.lower() not in ['y', 'yes']:
        return

    when = time.asctime(time.localtime())
    log = open(logfile, 'w')
    log.write("Log cleared on %s by %r\n" % (when, username))
    log.close()
    return


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('clear',
                          'Clear a 4SS Log',
                          '',
                          __doc__,
                          function = Run,
                          fileName = __file__,
                          )
    return cmd


