########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Commands/Restart.py,v 1.6 2004/09/09 21:31:49 jkloth Exp $
"""
4Suite repository restart command (4ss_manager restart)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """Restart the 4Suite server (controller)."""

from Ft.Server.Server import Launcher
from Ft.Server.Server.Commands.CommandUtil import GetRepository

def Run(options, args):

    username, password, properties, repo = GetRepository(options,
                                                         '4ss_manager.restart')
    repo.txRollback()

    filename = options.get('config-file')
    #force = options.get('force')
    try:
        launcher = Launcher.Launcher(username, password, properties)
        #launcher.restart(force)
        launcher.restart()
    except Exception, error:
        print str(error)
    return


def Register():
    from Ft.Lib.CommandLine import Command, Options

    cmd = Command.Command('restart',
                          "Restart the 4Suite server (controller)",
                          '',
                          __doc__,
                          function=Run,
                          #options=Options.Options([
                          #           Options.Option('f', 'force', 'Assume stale lock file if effort to kill process fails'),
                          #]),
                          fileName=__file__,
                          )
    return cmd

