<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fcore="http://xmlns.4suite.org/4ss/score" xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" xmlns:fhttp="http://xmlns.4suite.org/4ss/http" xmlns:exslt="http://exslt.org/common" xmlns:exslt-set="http://exslt.org/sets" xmlns:exslt-math="http://exslt.org/math" xmlns:exslt-functions="http://exslt.org/functions" xmlns:exslt-date-time="http://exslt.org/dates-and-times" xmlns:dc="&dc;" xmlns:fres="&fres;" xmlns:rdf="&rdf;" xmlns:f="&f;" extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <xsl:template name="ContainerForm">
    <table class="normal" cellpadding="4" cellspacing="1" width="100%">
      <input type="hidden" name="action" value="addContainer"/>
      <input type="hidden" name="parentContainer" value="{$managedResourcePath}"/>
      <tr>
        <td colspan="2" class="titleBar">
          <span class="blackTitle">Adding a Container to <xsl:value-of select="$managedResourcePath"/>
          </span>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">localName:</th>
        <td>
          <input type="text" name="localName" size="30"/>
        </td>
      </tr>
      <tr>
        <td colspan="2" align="center">
          <input type="submit" value="Add Container"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="DocumentForms">
    <xsl:param name="type" select="XML"/>
    <xsl:variable name="initialContent">
      <xsl:choose>
        <xsl:when test='$newResourceType = "RdfDoc"'><![CDATA[<?xml version="1.0" encoding="utf-8"?>
<rdf:RDF
  xmlns:rdf='&rdf;'
  xmlns:rdfs='&rdfs;'
>
</rdf:RDF>
]]></xsl:when>
        <xsl:when test='$newResourceType = "Xml"'>&lt;?xml version="1.0" encoding="utf-8"?></xsl:when>
        <xsl:when test='$newResourceType = "DocDef"'>&lt;?xml version="1.0" encoding="utf-8"?>
&lt;DocDef xmlns='http://xmlns.4suite.org/reserved' name=''>
&lt;!--
  &lt;NsMappings>
    &lt;NsMapping>
      &lt;Prefix>doc&lt;/Prefix>
      &lt;Uri>http://docbook.org/docbook/xml/4.0/namespace&lt;/Uri>
    &lt;/NsMapping>
  &lt;/NsMappings>
  &lt;RdfMapping>
    &lt;Subject>&lt;/Subject>
    &lt;Predicate>&lt;/Predicate>
    &lt;Object>&lt;/Object>
  &lt;/RdfMapping>
-->
&lt;/DocDef></xsl:when>
        <xsl:otherwise>&lt;?xml version="1.0"?>
&lt;!DOCTYPE xsl:stylesheet [
  &lt;!ENTITY nbsp "&#160;">
  &lt;!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  &lt;!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  &lt;!ENTITY f "http://xmlns.4suite.org/ext">
  &lt;!ENTITY fres "http://xmlns.4suite.org/reserved">
  &lt;!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
&lt;?xml version="1.0"?>
&lt;xsl:stylesheet
    version='1.0'
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
&lt;/xsl:stylesheet></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <table class="normal" cellpadding="4" cellspacing="1" width="100%">
      <input type="hidden" name="action" value="add{$type}Document"/>
      <input type="hidden" name="parentContainer" value="{$managedResourcePath}"/>
      <tr>
        <td colspan="2" class="titleBar">
          <span class="blackTitle">
            <xsl:text>Adding a</xsl:text>
            <xsl:if test="starts-with($type,'RDF') or contains('aeiox',translate(substring($type,1,1),'AEIOX','aeiox'))">n</xsl:if>
            <xsl:value-of select="concat(' ',$type,' Document')"/>
          </span>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">File:</th>
        <td>
          <input type="file" name="fileSrc" size="40"/>
        </td>
      </tr>
      <tr>
        <td colspan="2">
          <textarea cols="80" rows="20" name="textAreaSrc">
            <xsl:value-of select="$initialContent"/>
          </textarea>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">localName</th>
        <td>
          <input name="localName" type="text" size="30"/>
        </td>
      </tr>
      <xsl:choose>
        <xsl:when test='$type ="XML" or $type="XSLT"'>
          <tr>
            <th align="right" class="grayBar">Document Definition</th>
            <td>
              <input name="docdef" type="text" size="30"/>
            </td>
          </tr>
        </xsl:when>
      </xsl:choose>
      <tr>
        <td colspan="2" align="center">
          <input type="submit" value="Add {$type} Document"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="fileForm">
    <table class="normal" cellpadding="4" cellspacing="1" width="100%">
      <input type="hidden" name="action" value="addFile"/>
      <input type="hidden" name="parentContainer" value="{$managedResourcePath}"/>
      <tr>
        <td colspan="2" class="titleBar">
          <span class="blackTitle">Adding a Raw File</span>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">File:</th>
        <td>
          <input type="file" name="fileSrc" size="40"/>
        </td>
      </tr>
      <tr>
        <td colspan="2">
          <textarea cols="120" rows="20" name="textAreaSrc"/>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">localName</th>
        <td>
          <input name="localName" type="text" size="30"/>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">Internet Media Type</th>
        <td>
          <input name="imt" type="text" size="30"/>
        </td>
      </tr>
      <tr>
        <td colspan="2" align="center">
          <input type="submit" value="Add File"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="userForm">
    <table class="normal" cellpadding="4" cellspacing="1" width="100%">
      <input type="hidden" name="action" value="addUser"/>
      <input type="hidden" name="parentContainer" value="{$managedResourcePath}"/>
      <tr>
        <td colspan="2" class="titleBar">
          <span class="blackTitle">Adding a User</span>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">User Name</th>
        <td>
          <input type="text" size="30" name="username"/>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">New Password</th>
        <td>
          <input type="password" size="30" name="new-password"/>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">Renter New Password</th>
        <td>
          <input type="password" size="30" name="confirm-password"/>
        </td>
      </tr>
      <tr>
        <td colspan="2" align="center">
          <input type="submit" value="Add User"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="groupForm">
    <table class="normal" cellpadding="4" cellspacing="1" width="100%">
      <input type="hidden" name="action" value="addGroup"/>
      <input type="hidden" name="parentContainer" value="{$managedResourcePath}"/>
      <tr>
        <td colspan="2" class="titleBar">
          <span class="blackTitle">Adding a Group</span>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">Group Name</th>
        <td>
          <input type="text" size="30" name="groupname"/>
        </td>
      </tr>
      <tr>
        <td colspan="2" align="center">
          <input type="submit" value="Add Group"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="urireferenceForm">
    <table class="normal" cellpadding="4" cellspacing="1" width="100%">
      <input type="hidden" name="action" value="addUriReference"/>
      <input type="hidden" name="parentContainer" value="{$managedResourcePath}"/>
      <tr>
        <td colspan="2" class="titleBar">
          <span class="blackTitle">Adding a Uri Reference</span>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">localName</th>
        <td>
          <input name="localName" type="text" size="30"/>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">Internet Media Type</th>
        <td>
          <input name="imt" type="text" size="30"/>
        </td>
      </tr>
      <tr>
        <th align="right" class="grayBar">ReferenceUri</th>
        <td>
          <input type="text" size="40" name="referenceuri" value=""/>
        </td>
      </tr>
      <tr>
        <td colspan="2" align="center">
          <input type="submit" value="Add Uri Reference"/>
        </td>
      </tr>
    </table>
  </xsl:template>
</xsl:stylesheet>
