
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Class
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_interface, test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    

    reload(test_interface)
    test_interface.Test(tester,Class.Class)

    db = Database.Database()
    db.open(DBNAME)
    try:

        tester.startGroup("Class Interface %s Driver" % tester.test_data['driver'])

        test_metadata_util.test_primitive_collection(tester,db,Class.Class,'keys','key')
        test_metadata_util.test_primitive_collection(tester,db,Class.Class,'extents','extent')


        def GetClass(db,values):
            from Ft.Ods.MetaData import Class
            c = Class.Class(db,None)
            c.name='c1'
            return c
        test_metadata_util.test_form_drop(tester,db,Class.Class,'extensions',GetClass,nSided=1)
        def GetClass(db,values):
            from Ft.Ods.MetaData import Class
            c = Class.Class(db,None)
            c.name='c2'
            return c
        test_metadata_util.test_form_drop(tester,db,Class.Class,'extender',GetClass)



        tester.groupDone()
    finally:

        db.close()

