


from Ft.Rdf.Parsers import Versa
from Ft.Rdf.Parsers.Versa import SetFunctions

import test_helper

def test_all(tester,model):


    tester.startGroup("all")

    tester.startTest("all()")

    exp = Versa.Compile('all()')

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }
    con = Versa.CreateContext(model=model,
                              nsMapping = nsMap)

    tester.compare(1,isinstance(exp,SetFunctions.AllFunction))
    res = exp.evaluate(con)
    tester.compare(7, len(res))
    tester.compareIn(res,"http://fourthought.com")
    tester.compareIn(res,"http://fourthought.com#Male")
    tester.compareIn(res,"http://fourthought.com#Female")
    tester.compareIn(res,"http://foo.com#molson")
    tester.compareIn(res,"http://foo.com#jolson")
    tester.compareIn(res,"http://foo.com#T1")
    tester.compareIn(res,"http://foo.com#T2")
    tester.testDone()

    tester.groupDone()


def test_type(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }
    con = Versa.CreateContext(model=model,
                              nsMapping = nsMap)


    tester.startGroup('type')
    tester.startTest("type(ft:Male)")
    exp = Versa.Compile('type(ft:Male)')
    tester.compare(1,isinstance(exp,SetFunctions.TypeFunction))
    res = exp.evaluate(con)
    tester.compare(1, len(res))
    tester.compareIn(res,"http://foo.com#molson")
    tester.testDone()

    tester.startTest("type(ft:Person)")
    exp = Versa.Compile('type(ft:Person)')
    tester.compare(1,isinstance(exp,SetFunctions.TypeFunction))
    res = exp.evaluate(con)
    tester.compare(2, len(res))
    tester.compareIn(res,"http://foo.com#molson")
    tester.compareIn(res,"http://foo.com#jolson")
    tester.testDone()
    tester.groupDone()


def test_resource(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }
    con = Versa.CreateContext(model=model,
                              nsMapping = nsMap)

    tester.startGroup("resource")
    exp = "resource(foo:molson)"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,SetFunctions.ResourceFunction))
    res = exp.evaluate(con)
    tester.compare(res,"http://foo.com#molson")
    tester.testDone()

    tester.groupDone()

def test_filter(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }
    con = Versa.CreateContext(model=model,
                              nsMapping = nsMap)


    tester.startGroup('filter')
    exp = "filter(all(),*)"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,SetFunctions.FilterFunction))
    res = exp.evaluate(con)
    tester.compare(7, len(res))
    tester.compareIn(res,"http://fourthought.com")
    tester.compareIn(res,"http://fourthought.com#Male")
    tester.compareIn(res,"http://fourthought.com#Female")
    tester.compareIn(res,"http://foo.com#molson")
    tester.compareIn(res,"http://foo.com#jolson")
    tester.compareIn(res,"http://foo.com#T1")
    tester.compareIn(res,"http://foo.com#T2")
    tester.testDone()

    exp = "all()[*]"  #Short cut for the above expression
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,SetFunctions.FilterFunction))
    res = exp.evaluate(con)
    tester.compare(7, len(res))
    tester.compareIn(res,"http://fourthought.com")
    tester.compareIn(res,"http://fourthought.com#Male")
    tester.compareIn(res,"http://fourthought.com#Female")
    tester.compareIn(res,"http://foo.com#molson")
    tester.compareIn(res,"http://foo.com#jolson")
    tester.compareIn(res,"http://foo.com#T1")
    tester.compareIn(res,"http://foo.com#T2")
    tester.testDone()


    exp = "filter(all(),*,*)"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,SetFunctions.FilterFunction))
    res = exp.evaluate(con)
    tester.compare(7, len(res))
    tester.compareIn(res,"http://fourthought.com")
    tester.compareIn(res,"http://fourthought.com#Male")
    tester.compareIn(res,"http://fourthought.com#Female")
    tester.compareIn(res,"http://foo.com#molson")
    tester.compareIn(res,"http://foo.com#jolson")
    tester.compareIn(res,"http://foo.com#T1")
    tester.compareIn(res,"http://foo.com#T2")
    tester.testDone()

    exp = "all()[*][*]"  #Short cut for the above expression
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,SetFunctions.FilterFunction))
    res = exp.evaluate(con)
    tester.compare(7, len(res))
    tester.compareIn(res,"http://fourthought.com")
    tester.compareIn(res,"http://fourthought.com#Male")
    tester.compareIn(res,"http://fourthought.com#Female")
    tester.compareIn(res,"http://foo.com#molson")
    tester.compareIn(res,"http://foo.com#jolson")
    tester.compareIn(res,"http://foo.com#T1")
    tester.compareIn(res,"http://foo.com#T2")
    tester.testDone()


    tester.groupDone()

def test_map(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }
    con = Versa.CreateContext(model=model,
                              nsMapping = nsMap)

    tester.startGroup("distribute")

    exp = "distribute(all(),'.')"
    tester.startTest(exp)
    tester.warning("We need to decide what to do with .")
    tester.testDone()
    tester.groupDone()
    return
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,SetFunctions.MapFunction))
    res = exp.evaluate(con)
    tester.compare(5, len(res))
    expected = ["http://fourthought.com",
                "http://fourthought.com#Male",
                "http://fourthought.com#Female",
                "http://foo.com#molson",
                "http://foo.com#jolson"]

    for sub in res:
        tester.compareIn(expected,sub[0][0])
    tester.testDone()


    exp = "distribute(all(),'.','.')"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,SetFunctions.MapFunction))
    res = exp.evaluate(con)
    tester.compare(5, len(res))
    expected = ["http://fourthought.com",
                "http://fourthought.com#Male",
                "http://fourthought.com#Female",
                "http://foo.com#molson",
                "http://foo.com#jolson"]
    for sub in res:
        tester.compareIn(expected,sub[0][0])
        tester.compareIn(expected,sub[1][0])
    tester.testDone()


    tester.groupDone()

def test_sort(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }
    con = Versa.CreateContext(model=model,
                              nsMapping = nsMap)

    tester.startGroup('sort')

    exp = "sort(all())"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    tester.compare(1,isinstance(exp,SetFunctions.SortFunction))
    res = exp.evaluate(con)
    tester.compare(7, len(res))
    tester.compare("http://foo.com#T1",res[0])
    tester.compare("http://foo.com#T2",res[1])
    tester.compare("http://foo.com#jolson",res[2])
    tester.compare("http://foo.com#molson",res[3])
    tester.compare("http://fourthought.com",res[4])
    tester.compare("http://fourthought.com#Female",res[5])
    tester.compare("http://fourthought.com#Male",res[6])
    tester.testDone()

    tester.groupDone()


    

def Test(tester):
    model = test_helper.init(tester)
    test_all(tester,model)
    test_type(tester,model)
    test_resource(tester,model)
    test_filter(tester,model)
    test_map(tester,model)
    test_sort(tester,model)



if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)
