/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ScalableFreeformLayeredPane
extends FreeformLayeredPane
implements ScalableFigure {
    private double scale = 1.0;

    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        rect.width = (int)((double)rect.width / this.scale);
        rect.height = (int)((double)rect.height / this.scale);
        rect.x = (int)((double)rect.x / this.scale);
        rect.y = (int)((double)rect.y / this.scale);
        return rect;
    }

    public double getScale() {
        return this.scale;
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        if (this.scale == 1.0) {
            super.paintClientArea(graphics);
        } else {
            boolean optimizeClip;
            ScaledGraphics g = new ScaledGraphics(graphics);
            boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
            if (!optimizeClip) {
                g.clipRect(this.getBounds().getCropped(this.getInsets()));
            }
            g.scale(this.scale);
            g.pushState();
            this.paintChildren(g);
            g.dispose();
            graphics.restoreState();
        }
    }

    public void setScale(double newZoom) {
        this.scale = newZoom;
        this.superFireMoved();
        this.getFreeformHelper().invalidate();
        this.repaint();
    }

    public void translateToParent(Translatable t) {
        t.performScale(this.scale);
    }

    public void translateFromParent(Translatable t) {
        t.performScale(1.0 / this.scale);
    }

    protected final boolean useLocalCoordinates() {
        return false;
    }
}

