/*
 * Decompiled with CFR 0.152.
 */
package demo.swingset;

class Permuter {
    private int modulus;
    private int multiplier;
    private int addend = 22;

    public Permuter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.modulus = n;
        if (n == 1) {
            return;
        }
        this.multiplier = (int)Math.sqrt(n);
        while (Permuter.gcd(this.multiplier, n) != 1) {
            if (++this.multiplier != n) continue;
            this.multiplier = 1;
        }
    }

    public int map(int n) {
        return (this.multiplier * n + this.addend) % this.modulus;
    }

    private static int gcd(int n, int n2) {
        while (n2 != 0) {
            int n3 = n % n2;
            n = n2;
            n2 = n3;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        Permuter permuter = new Permuter(n);
        for (int i = 0; i < n; ++i) {
            System.out.print(permuter.map(i) + " ");
        }
        System.out.println();
    }
}

