/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Set;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.internal.themes.CascadingMap;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class Theme
implements ITheme {
    private CascadingColorRegistry themeColorRegistry;
    private CascadingFontRegistry themeFontRegistry;
    private IThemeDescriptor descriptor;
    private IPropertyChangeListener themeListener;
    private CascadingMap dataMap;
    private ListenerList propertyChangeListeners = new ListenerList();
    private ThemeRegistry themeRegistry = (ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry();

    public Theme(IThemeDescriptor descriptor) {
        this.descriptor = descriptor;
        if (descriptor != null) {
            FontDefinition[] fontDefinitions;
            IWorkbench workbench = WorkbenchPlugin.getDefault().getWorkbench();
            ColorDefinition[] definitions = this.descriptor.getColors();
            ITheme theme = workbench.getThemeManager().getTheme(IThemeManager.DEFAULT_THEME);
            if (definitions.length > 0) {
                this.themeColorRegistry = new CascadingColorRegistry(theme.getColorRegistry());
                ThemeElementHelper.populateRegistry((ITheme)this, definitions, workbench.getPreferenceStore());
            }
            if ((fontDefinitions = this.descriptor.getFonts()).length > 0) {
                this.themeFontRegistry = new CascadingFontRegistry(theme.getFontRegistry());
                ThemeElementHelper.populateRegistry((ITheme)this, fontDefinitions, workbench.getPreferenceStore());
            }
            this.dataMap = new CascadingMap(((ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry()).getData(), descriptor.getData());
        }
        this.getColorRegistry().addListener(this.getListener());
        this.getFontRegistry().addListener(this.getListener());
    }

    private IPropertyChangeListener getListener() {
        if (this.themeListener == null) {
            this.themeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    Theme.this.firePropertyChange(event);
                }
            };
        }
        return this.themeListener;
    }

    public ColorRegistry getColorRegistry() {
        if (this.themeColorRegistry != null) {
            return this.themeColorRegistry;
        }
        return JFaceResources.getColorRegistry();
    }

    public FontRegistry getFontRegistry() {
        if (this.themeFontRegistry != null) {
            return this.themeFontRegistry;
        }
        return JFaceResources.getFontRegistry();
    }

    public void dispose() {
        if (this.themeColorRegistry != null) {
            this.themeColorRegistry.removeListener(this.themeListener);
            this.themeColorRegistry.dispose();
        }
        if (this.themeFontRegistry != null) {
            this.themeFontRegistry.removeListener(this.themeListener);
            this.themeFontRegistry.dispose();
        }
    }

    public String getId() {
        return this.descriptor == null ? null : this.descriptor.getId();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.propertyChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public String getLabel() {
        return this.descriptor == null ? null : this.descriptor.getLabel();
    }

    public String getString(String key) {
        if (this.dataMap != null) {
            return (String)this.dataMap.get(key);
        }
        return (String)this.themeRegistry.getData().get(key);
    }

    public Set keySet() {
        if (this.dataMap != null) {
            return this.dataMap.keySet();
        }
        return this.themeRegistry.getData().keySet();
    }

    public int getInt(String key) {
        String string = this.getString(key);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean getBoolean(String key) {
        String string = this.getString(key);
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(this.getString(key));
    }
}

