/*
 * ui-mag.c - a module for magnification change UI
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ArrowB.h>
#include <Xm/Scale.h>
#include <Xm/RowColumn.h>

#include "cf-xmdvi.h"
#include "dvi-2_6.h"
#include "defs.h"
#include "dev.h"
#include "resource.h"
#include "window.h"
#include "ui.h"

Private Widget  dialog_mag; 
Private Widget  mag_slider;

#define MAG_DELTA  2
Private int   mag_minimum, mag_maximum, mag_current, mag_normal;

Private void  cb_mag_change(Widget,caddr_t,caddr_t);
Private void  cb_shrink(Widget,caddr_t,caddr_t);
Private void  cb_enlarge(Widget,caddr_t,caddr_t);
Private void  cb_normal_size(Widget,caddr_t,caddr_t);
Private void  set_mag(int);



Public Widget
x_make_panel_mag(Widget parent)
{
  Widget  xpop, xfm, xtitle, xb_close, xsep1;
  Widget  xfmag, xl_shrink, xl_enlarge, xb_shrink, xb_enlarge;
  Widget  xb_norm;
  Arg     args[15];
  int     i;

  mag_current = mag_normal = 1.0 * 10;
  mag_minimum = RES(DviDev,mag_min) * 10;
  mag_maximum = RES(DviDev,mag_max) * 10;

  i = 0;
  XtSetArg(args[i], XmNdialogStyle, XmDIALOG_MODELESS); i++;
  xpop = XmCreateBulletinBoardDialog(parent, "Magnifition", args, i);
  dialog_mag = xpop;

  xfm = XmCreateForm(xpop, "magnification", NULL, 0);
  XtManageChild(xfm);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Magnification", XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  xtitle = XmCreateLabel(xfm, "title", args, i);
  XtManageChild(xtitle);
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Close", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_NONE);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  xb_close  = XmCreatePushButton(xfm, "close", args, i);
  XtAddCallback(xb_close, XmNactivateCallback, 
		(XtCallbackProc)cb_mag_close, NULL);
  XtManageChild(xb_close);

  xsep1 = x_p_make_hsep(xfm);
  x_p_put_below(xsep1, xtitle);
  x_p_put_below(xsep1, xb_close);

  xfmag = XmCreateForm(xfm, "mag", NULL, 0);
  XtManageChild(xfmag);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Shrink", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);  i++;
  xl_shrink = XmCreateLabel(xfmag, "magShrinkLabel", args, i);
  XtManageChild(xl_shrink);
  i = 0;
  XtSetArg(args[i], XmNarrowDirection, XmARROW_LEFT); i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNleftWidget, xl_shrink);  i++;
  XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);  i++;
  xb_shrink = XmCreateArrowButton(xfmag, "magShrinkButton", args, i);
  XtAddCallback(xb_shrink, XmNactivateCallback, 
		(XtCallbackProc)cb_shrink, NULL);
  XtManageChild(xb_shrink);

  i = 0;
  XtSetArg(args[i], XmNorientation, XmHORIZONTAL); i++;
  XtSetArg(args[i], XmNshowValue, TRUE); i++;
  XtSetArg(args[i], XmNminimum, mag_minimum); i++;
  XtSetArg(args[i], XmNmaximum, mag_maximum); i++;
  XtSetArg(args[i], XmNvalue, mag_current); i++;
  XtSetArg(args[i], XmNdecimalPoints, 1); i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNleftWidget, xb_shrink); i++;
  XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);  i++;
  mag_slider = XmCreateScale(xfmag, "magSlider", args, i);
  XtAddCallback(mag_slider, XmNvalueChangedCallback, 
		(XtCallbackProc)cb_mag_change, NULL);
  XtManageChild(mag_slider);

  i = 0;
  XtSetArg(args[i], XmNarrowDirection, XmARROW_RIGHT); i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNleftWidget, mag_slider); i++;
  XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);  i++;
  xb_enlarge = XmCreateArrowButton(xfmag, "magEnlargeButton", args, i); 
  XtAddCallback(xb_enlarge, XmNactivateCallback, 
		(XtCallbackProc)cb_enlarge, NULL);
  XtManageChild(xb_enlarge);
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Enlarge", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNleftWidget, xb_enlarge); i++;
  XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);  i++;
  xl_enlarge = XmCreateLabel(xfmag, "magEnlargeLabel", args, i);
  XtManageChild(xl_enlarge);

  x_p_put_below(xfmag, xsep1);
  
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Set Normal Size", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_NONE);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, xfmag); i++;
  XtSetArg(args[i], XmNbottomAttachment, XmATTACH_NONE);  i++;
  xb_norm = XmCreatePushButton(xfm, "magSetNormal", args, i);
  XtAddCallback(xb_norm, XmNactivateCallback, 
		(XtCallbackProc)cb_normal_size, NULL);
  XtManageChild(xb_norm);


  return xpop;
}


Public void
cb_mag(Widget w, caddr_t d1, caddr_t d2)
{
  if (XtIsManaged(dialog_mag)){
    XtUnmanageChild(dialog_mag);
  } else {
    ui_close_panel_all();
    XtManageChild(dialog_mag);
  }
}

Public void
cb_mag_close(Widget w, caddr_t d1, caddr_t d2)
{
  if (XtIsManaged(dialog_mag))
    XtUnmanageChild(dialog_mag);
}


Private void  
cb_mag_change(Widget w, caddr_t d1, caddr_t d2)
{
  Arg   arg;
  int   mag;

  XtSetArg(arg, XmNvalue, &mag);
  XtGetValues(w, &arg, 1);
  set_mag(mag);
}

Private void  
cb_shrink(Widget w, caddr_t d1, caddr_t d2)
{
  cmd_magnify_shrink();
}

Private void  
cb_enlarge(Widget w, caddr_t d1, caddr_t d2)
{
  cmd_magnify_enlarge();
}

Private void  
cb_normal_size(Widget w, caddr_t d1, caddr_t d2)
{
  if (mag_current == mag_normal)
    return;
  set_mag(mag_normal);
}

Private void  
set_mag(int mag)
{
  Arg    args[2];

  if (mag_current == mag)
    return;

  mag_current = mag;
  XtSetArg(args[0], XmNvalue, mag_current);
  XtSetValues(mag_slider, args, 1);
  DviShrinkFactor = RES(DviDev,shrink)*10.0/mag_current;
  ui_preview_mag_changed(NULL, NULL);
  x_ui_command = UI_CMD_PAGE;
}

Public void
cmd_magnify_enlarge(void)
{
  if (DviDisableCommand == 1)
    return;
  if (mag_maximum < (mag_current + MAG_DELTA))
    x_bell();
  else
    set_mag(mag_current + MAG_DELTA);
}

Public void
cmd_magnify_shrink(void)
{
  if (DviDisableCommand == 1)
    return;
  if ((mag_current - MAG_DELTA) < mag_minimum)
    x_bell();
  else
    set_mag(mag_current - MAG_DELTA);
}

