/*
 * Copyright (C) 2004  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _H_FINDVIEW
#define _H_FINDVIEW

#include <AppKit/NSView.h>
#include <AppKit/NSTextField.h>

/**
 * A view that let's the user enter some text to
 * search for. The user can navigate to the next
 * and pervious match.
 */
@interface FindView : NSView
{
   NSTextField*  text;
}

- (id) initWithFrame: (NSRect)aFrame;

- (void) activate;
- (void) deactivate;

@end

#endif
