/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <string.h>

#include "lib_usb.h"

const char *
cim_usb_debug_pid2str(unsigned char pid)
{
	switch (pid) {
	case USB_PID_SOF:
		return "SOF";
	case USB_PID_SETUP:
		return "SETUP";
	case USB_PID_IN:
		return "IN";
	case USB_PID_OUT:
		return "OUT";
	case USB_PID_DATA0:
		return "DATA0";
	case USB_PID_DATA1:
		return "DATA1";
	case USB_PID_ACK:
		return "ACK";
	case USB_PID_NAK:
		return "NAK";
	case USB_PID_STALL:
		return "STALL";
	case USB_PID_PRE:
		return "PRE";
	default:
		return "unknown/invalid";
	}
}

const char *
cim_usb_debug_descriptortype2str(unsigned int descriptor_type)
{
	switch (descriptor_type) {
	case USB_DESCRIPTOR_TYPE_DEVICE:
		return "DEVICE";
	case USB_DESCRIPTOR_TYPE_CONFIGURATION:
		return "CONFIGURATION";
	case USB_DESCRIPTOR_TYPE_STRING:
		return "STRING";
	case USB_DESCRIPTOR_TYPE_INTERFACE:
		return "INTERFACE";
	case USB_DESCRIPTOR_TYPE_ENDPOINT:
		return "ENDPOINT";
	default:
		return "unknown/invalid";
	}
}

const char *
cim_usb_debug_defaultrequest2str(unsigned char bRequest)
{
	switch (bRequest) {
	case USB_DEV_REQ_GET_STATUS:
		return "GetStatus";
	case USB_DEV_REQ_CLEAR_FEATURE:
		return "ClearFeature";
	case USB_DEV_REQ_SET_FEATURE:
		return "SetFeature";
	case USB_DEV_REQ_SET_ADDRESS:
		return "SetAddress";
	case USB_DEV_REQ_GET_DESCRIPTOR:
		return "GetDescriptor";
	case USB_DEV_REQ_SET_DESCRIPTOR:
		return "SetDescriptor";
	case USB_DEV_REQ_GET_CONFIGURATION:
		return "GetConfiguration";
	case USB_DEV_REQ_SET_CONFIGURATION:
		return "SetConfiguration";
	case USB_DEV_REQ_GET_INTERFACE:
		return "GetInterface";
	case USB_DEV_REQ_SET_INTERFACE:
		return "SetInterface";
	case USB_DEV_REQ_SYNCH_FRAME:
		return "SynchFrame";
	default:
		return "unknown/invalid";
	}
}
